/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.instruments;

import org.jquantlib.QL;
import org.jquantlib.Settings;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.instruments.ForwardTypePayoff;
import org.jquantlib.instruments.Instrument;
import org.jquantlib.instruments.Payoff;
import org.jquantlib.quotes.Handle;
import org.jquantlib.termstructures.Compounding;
import org.jquantlib.termstructures.InterestRate;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.time.BusinessDayConvention;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Period;
import org.jquantlib.time.TimeUnit;

public abstract class Forward
extends Instrument {
    protected int settlementDays;
    protected Date maturityDate;
    protected Date valueDate;
    protected Calendar calendar;
    protected DayCounter dayCounter;
    protected BusinessDayConvention businessDayConvention;
    protected Handle<YieldTermStructure> discountCurve;
    protected Handle<YieldTermStructure> incomeDiscountCurve;
    protected ForwardTypePayoff payoff;
    protected double underlyingSpotValue;
    protected double underlyingIncome;

    protected Forward(DayCounter dc, Calendar cal, BusinessDayConvention bdc, int settlementDays, Payoff payoff, Date valueDate, Date maturityDate) {
        this(dc, cal, bdc, settlementDays, payoff, valueDate, maturityDate, new Handle<YieldTermStructure>());
    }

    protected Forward(DayCounter dc, Calendar cal, BusinessDayConvention bdc, int settlementDays, Payoff payoff, Date valueDate, Date maturityDate, Handle<YieldTermStructure> discountCurve) {
        this.dayCounter = dc;
        this.calendar = cal;
        this.businessDayConvention = bdc;
        this.settlementDays = settlementDays;
        this.maturityDate = this.calendar.adjust(maturityDate, this.businessDayConvention);
        this.discountCurve = discountCurve;
        this.payoff = (ForwardTypePayoff)payoff;
        this.valueDate = valueDate;
        new Settings().evaluationDate().addObserver(this);
        discountCurve.addObserver(this);
    }

    public abstract double spotValue();

    public abstract double spotIncome(Handle<YieldTermStructure> var1);

    public double forwardValue() {
        this.calculate();
        return (this.underlyingSpotValue - this.underlyingIncome) / this.discountCurve.currentLink().discount(this.maturityDate);
    }

    public InterestRate impliedYield(double underlyingSpotValue, double forwardValue, Date settlementDate, Compounding compoundingConvention, DayCounter dayCounter) {
        double tenor = dayCounter.yearFraction(settlementDate, this.maturityDate);
        double compoundingFactor = forwardValue / (underlyingSpotValue - this.spotIncome(this.incomeDiscountCurve));
        return InterestRate.impliedRate(compoundingFactor, tenor, dayCounter, compoundingConvention);
    }

    public BusinessDayConvention businessDayConvention() {
        return this.businessDayConvention;
    }

    public Calendar calendar() {
        return this.calendar;
    }

    public Date settlementDate() {
        Period advance = new Period(this.settlementDays, TimeUnit.Days);
        Date settle = this.calendar.advance(new Settings().evaluationDate(), advance);
        if (settle.gt(this.valueDate)) {
            return settle;
        }
        return this.valueDate;
    }

    public DayCounter dayCounter() {
        return this.dayCounter;
    }

    public Handle<YieldTermStructure> discountCurve() {
        return this.discountCurve;
    }

    public Handle<YieldTermStructure> incomeDiscountCurve() {
        return this.incomeDiscountCurve;
    }

    @Override
    public void performCalculations() {
        QL.require(this.discountCurve != null, " Discount Curve must be set for Forward");
        this.NPV = this.payoff.get(this.forwardValue()) * this.discountCurve.currentLink().discount(this.maturityDate);
    }

    @Override
    public boolean isExpired() {
        return this.valueDate.gt(this.maturityDate);
    }
}

