/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.instruments;

import org.jquantlib.QL;
import org.jquantlib.exercise.Exercise;
import org.jquantlib.instruments.BarrierType;
import org.jquantlib.instruments.OneAssetOption;
import org.jquantlib.instruments.StrikedTypePayoff;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.pricingengines.GenericEngine;
import org.jquantlib.pricingengines.PricingEngine;

public class BarrierOption
extends OneAssetOption {
    protected BarrierType barrierType;
    protected double barrier;
    protected double rebate;

    public BarrierOption(BarrierType barrierType, double barrier, double rebate, StrikedTypePayoff payoff, Exercise exercise) {
        super(payoff, exercise);
        this.barrierType = barrierType;
        this.barrier = barrier;
        this.rebate = rebate;
    }

    @Override
    public void setupArguments(PricingEngine.Arguments arguments) {
        super.setupArguments(arguments);
        QL.require(OneAssetOption.Arguments.class.isAssignableFrom(arguments.getClass()), "Unexpected type for type parameter");
        ArgumentsImpl a = (ArgumentsImpl)arguments;
        a.barrierType = this.barrierType;
        a.barrier = this.barrier;
        a.rebate = this.rebate;
    }

    public static abstract class EngineImpl
    extends GenericEngine<OneAssetOption.Arguments, OneAssetOption.Results> {
        private final ArgumentsImpl a;

        protected EngineImpl() {
            super(new ArgumentsImpl(), new ResultsImpl());
            this.a = (ArgumentsImpl)this.arguments_;
        }

        protected boolean triggered(double underlying) {
            switch (this.a.barrierType) {
                case DownIn: 
                case DownOut: {
                    return underlying < this.a.barrier;
                }
                case UpIn: 
                case UpOut: {
                    return underlying > this.a.barrier;
                }
            }
            throw new LibraryException("Unknown type");
        }
    }

    public static class ResultsImpl
    extends OneAssetOption.ResultsImpl
    implements OneAssetOption.Results {
    }

    public static class ArgumentsImpl
    extends OneAssetOption.ArgumentsImpl
    implements OneAssetOption.Arguments {
        private static final String UNKNOWN_TYPE = "unknown type";
        public BarrierType barrierType = BarrierType.Unknown;
        public double barrier = Double.MAX_VALUE;
        public double rebate = Double.MAX_VALUE;

        @Override
        public void validate() {
            super.validate();
            switch (this.barrierType) {
                case DownIn: 
                case UpIn: 
                case DownOut: 
                case UpOut: {
                    break;
                }
                default: {
                    throw new LibraryException(UNKNOWN_TYPE);
                }
            }
            QL.require(!Double.isNaN(this.barrier), "no barrier given");
            QL.require(!Double.isNaN(this.rebate), "no rebate given");
        }
    }
}

