/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.indexes;

import java.util.Iterator;
import java.util.List;
import org.jquantlib.QL;
import org.jquantlib.indexes.IndexManager;
import org.jquantlib.lang.iterators.Iterables;
import org.jquantlib.math.Closeness;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.TimeSeries;
import org.jquantlib.util.DefaultObservable;
import org.jquantlib.util.Observable;
import org.jquantlib.util.Observer;

public abstract class Index
implements Observable {
    private final Observable delegatedObservable = new DefaultObservable(this);

    public abstract String name();

    public abstract Calendar fixingCalendar();

    public abstract boolean isValidFixingDate(Date var1);

    public abstract double fixing(Date var1, boolean var2);

    public TimeSeries<Double> timeSeries() {
        return IndexManager.getInstance().getHistory(this.name());
    }

    public void addFixing(Date date, double value) {
        this.addFixing(date, value, false);
    }

    public void addFixing(Date date, double value, boolean forceOverwrite) {
        boolean missingFixing;
        String tag = this.name();
        boolean noInvalidFixing = true;
        boolean noDuplicatedFixing = true;
        TimeSeries<Double> h = IndexManager.getInstance().getHistory(tag);
        boolean validFixing = this.isValidFixingDate(date);
        Double currentValue = (Double)h.get(date);
        boolean bl = missingFixing = forceOverwrite || Closeness.isClose(currentValue, Double.MAX_VALUE);
        if (validFixing) {
            if (missingFixing) {
                h.put(date, value);
            } else if (!Closeness.isClose(currentValue, value)) {
                noDuplicatedFixing = false;
            }
        } else {
            noInvalidFixing = false;
        }
        IndexManager.getInstance().setHistory(tag, h);
        QL.ensure(noInvalidFixing, "at least one invalid fixing provided");
        QL.ensure(noDuplicatedFixing, "at least one duplicated fixing provided");
    }

    public final void addFixings(Iterator<Date> dates, Iterator<Double> values, boolean forceOverwrite) {
        String tag = this.name();
        boolean noInvalidFixing = true;
        boolean noDuplicatedFixing = true;
        TimeSeries<Double> h = IndexManager.getInstance().getHistory(tag);
        for (Date date : Iterables.unmodifiableIterable(dates)) {
            boolean missingFixing;
            double value = values.next();
            boolean validFixing = this.isValidFixingDate(date);
            double currentValue = (Double)h.get(date);
            boolean bl = missingFixing = forceOverwrite || Closeness.isClose(currentValue, Double.MAX_VALUE);
            if (validFixing) {
                if (missingFixing) {
                    h.put(date, value);
                    continue;
                }
                if (Closeness.isClose(currentValue, value)) continue;
                noDuplicatedFixing = false;
                continue;
            }
            noInvalidFixing = false;
        }
        IndexManager.getInstance().setHistory(tag, h);
        QL.ensure(noInvalidFixing, "at least one invalid fixing provided");
        QL.ensure(noDuplicatedFixing, "at least one duplicated fixing provided");
    }

    public final void clearFixings() {
        IndexManager.getInstance().clearHistory(this.name());
    }

    public double fixing(Date fixingDate) {
        return this.fixing(fixingDate, false);
    }

    @Override
    public void addObserver(Observer observer) {
        this.delegatedObservable.addObserver(observer);
    }

    @Override
    public int countObservers() {
        return this.delegatedObservable.countObservers();
    }

    @Override
    public void deleteObserver(Observer observer) {
        this.delegatedObservable.deleteObserver(observer);
    }

    @Override
    public void notifyObservers() {
        this.delegatedObservable.notifyObservers();
    }

    @Override
    public void notifyObservers(Object arg) {
        this.delegatedObservable.notifyObservers(arg);
    }

    @Override
    public void deleteObservers() {
        this.delegatedObservable.deleteObservers();
    }

    @Override
    public List<Observer> getObservers() {
        return this.delegatedObservable.getObservers();
    }
}

