/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.indexes;

import org.jquantlib.QL;
import org.jquantlib.currencies.America;
import org.jquantlib.daycounters.ActualActual;
import org.jquantlib.indexes.InterestRateIndex;
import org.jquantlib.quotes.Handle;
import org.jquantlib.termstructures.Compounding;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.time.BusinessDayConvention;
import org.jquantlib.time.Date;
import org.jquantlib.time.MakeSchedule;
import org.jquantlib.time.Period;
import org.jquantlib.time.Schedule;
import org.jquantlib.time.TimeUnit;
import org.jquantlib.time.Weekday;
import org.jquantlib.time.calendars.UnitedStates;

public class BMAIndex
extends InterestRateIndex {
    private final Handle<YieldTermStructure> termStructure;

    public BMAIndex() {
        this(new Handle<YieldTermStructure>());
    }

    public BMAIndex(Handle<YieldTermStructure> h) {
        super("BMA", new Period(1, TimeUnit.Weeks), 1, new America.USDCurrency(), new UnitedStates(UnitedStates.Market.NYSE), new ActualActual(ActualActual.Convention.ISDA));
        this.termStructure = h;
        if (this.termStructure != null) {
            this.termStructure.addObserver(this);
        }
    }

    public BMAIndex clone(Handle<YieldTermStructure> h) {
        BMAIndex clone = new BMAIndex(h);
        return clone;
    }

    @Override
    public String name() {
        return "BMA";
    }

    public Schedule fixingSchedule(Date start, Date end) {
        return new MakeSchedule(this.previousWednesday(start), this.nextWednesday(end), new Period(1, TimeUnit.Weeks), this.fixingCalendar, BusinessDayConvention.Following).forwards().schedule();
    }

    @Override
    protected double forecastFixing(Date fixingDate) {
        QL.require(!this.termStructure.empty(), "no forecasting term structure set to " + this.name());
        Date start = this.fixingCalendar().advance(fixingDate, 1, TimeUnit.Days);
        Date end = this.maturityDate(start);
        return this.termStructure.currentLink().forwardRate(start, end, this.dayCounter, Compounding.Simple).rate();
    }

    @Override
    public boolean isValidFixingDate(Date fixingDate) {
        Date d = this.previousWednesday(fixingDate);
        while (d.lt(fixingDate)) {
            if (this.fixingCalendar.isBusinessDay(d)) {
                return false;
            }
            d.inc();
        }
        return this.fixingCalendar.isBusinessDay(fixingDate);
    }

    @Override
    public Handle<YieldTermStructure> termStructure() {
        return this.termStructure;
    }

    @Override
    public Date maturityDate(Date valueDate) {
        Date fixingDate = this.fixingCalendar().advance(valueDate, -1, TimeUnit.Days);
        Date nextWednesday = this.nextWednesday(fixingDate);
        return this.fixingCalendar().advance(nextWednesday, 1, TimeUnit.Days);
    }

    private Date previousWednesday(Date date) {
        Weekday w = date.weekday();
        if (w.value() >= 4) {
            return date.subAssign(w.value() - 4);
        }
        return date.addAssign(4 - w.value() - 7);
    }

    private Date nextWednesday(Date date) {
        return this.previousWednesday(date.addAssign(7));
    }
}

