/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.daycounters;

import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.daycounters.Thirty360;
import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.time.Date;

@QualityAssurance(quality=QualityAssurance.Quality.Q4_UNIT, version=QualityAssurance.Version.V097, reviewers={"Richard Gomes"})
public class SimpleDayCounter
extends DayCounter {
    public SimpleDayCounter() {
        this.impl = new Impl();
    }

    private final class Impl
    extends DayCounter.Impl {
        private final DayCounter fallback = new Thirty360();

        private Impl() {
        }

        @Override
        protected final String name() {
            return "Simple";
        }

        @Override
        protected long dayCount(Date dateStart, Date dateEnd) {
            return this.fallback.dayCount(dateStart, dateEnd);
        }

        @Override
        protected final double yearFraction(Date dateStart, Date dateEnd, Date refPeriodStart, Date refPeriodEnd) {
            int dm1 = dateStart.dayOfMonth();
            int dm2 = dateEnd.dayOfMonth();
            int mm1 = dateStart.month().value();
            int mm2 = dateEnd.month().value();
            int yy1 = dateStart.year();
            int yy2 = dateEnd.year();
            if (dm1 == dm2 || dm1 > dm2 && Date.isEndOfMonth(dateEnd) || dm1 < dm2 && Date.isEndOfMonth(dateStart)) {
                return (double)(yy2 - yy1) + (double)(mm2 - mm1) / 12.0;
            }
            return this.fallback.yearFraction(dateStart, dateEnd, refPeriodStart, refPeriodEnd);
        }
    }
}

