/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.daycounters;

import org.jquantlib.QL;
import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.time.Date;

@QualityAssurance(quality=QualityAssurance.Quality.Q4_UNIT, version=QualityAssurance.Version.V097, reviewers={"Richard Gomes"})
public class DayCounter {
    private static final String NO_IMPLEMENTATION_PROVIDED = "no implementation provided";
    protected Impl impl;

    public boolean empty() {
        return this.impl == null;
    }

    public String name() {
        QL.require(this.impl != null, NO_IMPLEMENTATION_PROVIDED);
        return this.impl.name();
    }

    public long dayCount(Date dateStart, Date dateEnd) {
        QL.require(this.impl != null, NO_IMPLEMENTATION_PROVIDED);
        return this.impl.dayCount(dateStart, dateEnd);
    }

    public double yearFraction(Date dateStart, Date dateEnd) {
        return this.yearFraction(dateStart, dateEnd, null, null);
    }

    public double yearFraction(Date dateStart, Date dateEnd, Date refPeriodStart, Date refPeriodEnd) {
        QL.require(this.impl != null, NO_IMPLEMENTATION_PROVIDED);
        return this.impl.yearFraction(dateStart, dateEnd, refPeriodStart, refPeriodEnd);
    }

    public boolean eq(DayCounter another) {
        return this.equals(another);
    }

    public boolean ne(DayCounter another) {
        return !this.equals(another);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.impl == null ? 0 : this.impl.hashCode());
        result = 31 * result + (this.impl == null ? 0 : this.name().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return obj instanceof DayCounter && ((DayCounter)obj).fEquals(this);
    }

    public String toString() {
        return this.impl == null ? "null" : this.impl.name();
    }

    protected boolean fEquals(DayCounter other) {
        if (this.empty() && other.empty()) {
            return true;
        }
        return this.name().equals(other.name());
    }

    protected abstract class Impl {
        protected Impl() {
        }

        protected abstract String name();

        protected abstract double yearFraction(Date var1, Date var2, Date var3, Date var4);

        protected long dayCount(Date dateStart, Date dateEnd) {
            return dateEnd.sub(dateStart);
        }
    }
}

