/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.daycounters;

import org.jquantlib.QL;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.time.Date;
import org.jquantlib.time.Month;
import org.jquantlib.time.Period;
import org.jquantlib.time.TimeUnit;

@QualityAssurance(quality=QualityAssurance.Quality.Q4_UNIT, version=QualityAssurance.Version.V097, reviewers={"Richard Gomes"})
public class ActualActual
extends DayCounter {
    public ActualActual() {
        this(Convention.ISDA);
    }

    public ActualActual(Convention c) {
        switch (c) {
            case ISMA: 
            case Bond: {
                this.impl = new ImplISMA();
                break;
            }
            case ISDA: 
            case Historical: 
            case Actual365: {
                this.impl = new ImplISDA();
                break;
            }
            case AFB: 
            case Euro: {
                this.impl = new ImplAFB();
                break;
            }
            default: {
                throw new LibraryException("unknown act/act convention");
            }
        }
    }

    private final class ImplAFB
    extends DayCounter.Impl {
        private ImplAFB() {
            super(ActualActual.this);
        }

        @Override
        public final String name() {
            return "Actual/Actual (AFB)";
        }

        @Override
        public final double yearFraction(Date dateStart, Date dateEnd, Date refPeriodStart, Date refPeriodEnd) {
            if (dateStart.equals(dateEnd)) {
                return 0.0;
            }
            if (dateStart.gt(dateEnd)) {
                return -1.0 * this.yearFraction(dateEnd, dateStart, new Date(), new Date());
            }
            Date newD2 = dateEnd;
            Date temp = dateEnd;
            double sum = 0.0;
            while (temp.gt(dateStart)) {
                temp = newD2.add(Period.ONE_YEAR_BACKWARD);
                if (temp.dayOfMonth() == 28 && temp.month().value() == 2 && Date.isLeap(temp.year())) {
                    temp.inc();
                }
                if (!temp.ge(dateStart)) continue;
                sum += 1.0;
                newD2 = temp;
            }
            double den = 365.0;
            if (Date.isLeap(newD2.year())) {
                if (newD2.gt(new Date(29, Month.February, newD2.year())) && dateStart.le(new Date(29, Month.February, newD2.year()))) {
                    den += 1.0;
                }
            } else if (Date.isLeap(dateStart.year()) && newD2.gt(new Date(29, Month.February, dateStart.year())) && dateStart.le(new Date(29, Month.February, dateStart.year()))) {
                den += 1.0;
            }
            return sum + (double)this.dayCount(dateStart, newD2) / den;
        }
    }

    private final class ImplISDA
    extends DayCounter.Impl {
        private ImplISDA() {
            super(ActualActual.this);
        }

        @Override
        public final String name() {
            return "Actual/Actual (ISDA)";
        }

        @Override
        public final double yearFraction(Date dateStart, Date dateEnd, Date refPeriodStart, Date refPeriodEnd) {
            if (dateStart.equals(dateEnd)) {
                return 0.0;
            }
            if (dateStart.gt(dateEnd)) {
                return -this.yearFraction(dateEnd, dateStart, new Date(), new Date());
            }
            int y1 = dateStart.year();
            int y2 = dateEnd.year();
            double dib1 = Date.isLeap(dateStart.year()) ? 366.0 : 365.0;
            double dib2 = Date.isLeap(dateEnd.year()) ? 366.0 : 365.0;
            double sum = y2 - y1 - 1;
            sum += (dib1 - (double)dateStart.dayOfYear() + 1.0) / dib1;
            return sum += (double)(dateEnd.dayOfYear() - 1) / dib2;
        }
    }

    private final class ImplISMA
    extends DayCounter.Impl {
        private ImplISMA() {
            super(ActualActual.this);
        }

        @Override
        public final String name() {
            return "Actual/Actual (ISMA)";
        }

        @Override
        public final double yearFraction(Date d1, Date d2, Date d3, Date d4) {
            Date newRefEnd;
            Date newRefStart;
            if (d1.equals(d2)) {
                return 0.0;
            }
            if (d1.gt(d2)) {
                return -this.yearFraction(d2, d1, d3, d4);
            }
            Date refPeriodStart = !d3.isNull() ? d3 : d1;
            Date refPeriodEnd = !d4.isNull() ? d4 : d2;
            QL.ensure(refPeriodEnd.gt(refPeriodStart) && refPeriodEnd.gt(d1), "invalid reference period");
            int months = (int)(0.5 + (double)(12L * refPeriodEnd.sub(refPeriodStart)) / 365.0);
            if (months == 0) {
                refPeriodStart = d1;
                refPeriodEnd = d1.add(Period.ONE_YEAR_FORWARD);
                months = 12;
            }
            double period = (double)months / 12.0;
            if (d2.le(refPeriodEnd)) {
                if (d1.ge(refPeriodStart)) {
                    return period * (double)this.dayCount(d1, d2) / (double)this.dayCount(refPeriodStart, refPeriodEnd);
                }
                Date previousRef = refPeriodStart.add(new Period(-months, TimeUnit.Months));
                if (d2.gt(refPeriodStart)) {
                    return this.yearFraction(d1, refPeriodStart, previousRef, refPeriodStart) + this.yearFraction(refPeriodStart, d2, refPeriodStart, refPeriodEnd);
                }
                return this.yearFraction(d1, d2, previousRef, refPeriodStart);
            }
            QL.require(refPeriodStart.le(d1), "invalid dates");
            double sum = this.yearFraction(d1, refPeriodEnd, refPeriodStart, refPeriodEnd);
            int i = 0;
            while (true) {
                newRefStart = refPeriodEnd.add(new Period(months * i, TimeUnit.Months));
                newRefEnd = refPeriodEnd.add(new Period(months * (i + 1), TimeUnit.Months));
                if (d2.lt(newRefEnd)) break;
                sum += period;
                ++i;
            }
            return sum += this.yearFraction(newRefStart, d2, newRefStart, newRefEnd);
        }
    }

    public static enum Convention {
        ISMA,
        Bond,
        ISDA,
        Historical,
        Actual365,
        AFB,
        Euro;

    }
}

