/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.currencies;

import org.jquantlib.QL;
import org.jquantlib.currencies.Currency;
import org.jquantlib.currencies.ExchangeRate;
import org.jquantlib.currencies.ExchangeRateManager;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.math.Closeness;

public class Money
implements Cloneable {
    public static ConversionType conversionType;
    public static Currency baseCurrency;
    private double value_;
    private Currency currency_;

    public Money() {
        QL.validateExperimentalMode();
        this.value_ = 0.0;
    }

    public Money(Currency currency, double value) {
        QL.validateExperimentalMode();
        this.value_ = value;
        this.currency_ = currency;
    }

    public Money(double value, Currency currency) {
        QL.validateExperimentalMode();
        this.value_ = value;
        this.currency_ = currency.clone();
    }

    public Money clone() {
        Money money = new Money();
        money.currency_ = this.currency_.clone();
        money.value_ = this.value_;
        return money;
    }

    public Currency currency() {
        return this.currency_;
    }

    public double value() {
        return this.value_;
    }

    public Money rounded() {
        return new Money(this.currency_.rounding().operator(this.value_), this.currency_);
    }

    public Money positiveValue() {
        return new Money(this.currency_, this.value_);
    }

    public Money negativeValue() {
        return new Money(-this.value_, this.currency_);
    }

    public Money mulAssign(double x) {
        this.value_ *= x;
        return this;
    }

    public Money divAssign(double x) {
        this.value_ /= x;
        return this;
    }

    public Money add(Money money) {
        Money tmp = this.clone();
        tmp.addAssign(money);
        return tmp;
    }

    public Money sub(Money money) {
        Money tmp = this.clone();
        tmp.subAssign(money);
        return tmp;
    }

    public Money mul(double x) {
        Money tmp = this.clone();
        tmp.mulAssign(x);
        return tmp;
    }

    public Money div(double x) {
        Money tmp = this.clone();
        tmp.value_ /= x;
        return tmp;
    }

    public boolean notEquals(Money money) {
        return !this.equals(money);
    }

    public boolean greater(Money money) {
        return money.greater(this);
    }

    public boolean greaterEqual(Money money) {
        return money.greaterEqual(this);
    }

    public Money operatorMultiply(double value, Currency c) {
        return new Money(value, c);
    }

    public static Money multiple(Currency c, double value) {
        return new Money(value, c);
    }

    public static Money multiple(double value, Currency c) {
        return new Money(value, c);
    }

    public void convertTo(Currency target) {
        if (this.currency().ne(target)) {
            ExchangeRate rate = ExchangeRateManager.getInstance().lookup(this.currency(), target);
            Money money = rate.exchange(this).rounded();
            this.currency_ = money.currency_;
            this.value_ = money.value_;
        }
    }

    public void convertToBase() {
        QL.require(!baseCurrency.empty(), "no base currency set");
        this.convertTo(baseCurrency);
    }

    public Money addAssign(Money money) {
        if (this.currency_.eq(money.currency_)) {
            this.value_ += money.value_;
        } else if (conversionType == ConversionType.BaseCurrencyConversion) {
            this.convertToBase();
            Money tmp = money.clone();
            tmp.convertToBase();
            this.addAssign(tmp);
        } else if (conversionType == ConversionType.AutomatedConversion) {
            Money tmp = money.clone();
            tmp.convertTo(this.currency_);
            this.addAssign(tmp);
        } else {
            throw new LibraryException("currency mismatch and no conversion specified");
        }
        return this;
    }

    public Money subAssign(Money money) {
        if (this.currency_.eq(money.currency_)) {
            this.value_ -= money.value_;
        } else if (conversionType == ConversionType.BaseCurrencyConversion) {
            this.convertToBase();
            Money tmp = money.clone();
            tmp.convertToBase();
            this.subAssign(tmp);
        } else if (conversionType == ConversionType.AutomatedConversion) {
            Money tmp = money.clone();
            tmp.convertTo(this.currency_);
            this.subAssign(tmp);
        } else {
            throw new LibraryException("currency mismatch and no conversion specified");
        }
        return this;
    }

    public double div(Money money) {
        if (this.currency().eq(money.currency())) {
            return this.value_ / money.value();
        }
        if (conversionType == ConversionType.BaseCurrencyConversion) {
            Money tmp1 = this.clone();
            tmp1.convertToBase();
            Money tmp2 = money.clone();
            tmp2.convertToBase();
            return this.div(tmp2);
        }
        if (conversionType == ConversionType.AutomatedConversion) {
            Money tmp = money.clone();
            tmp.convertTo(money.currency());
            return this.div(tmp);
        }
        throw new LibraryException("currency mismatch and no conversion specified");
    }

    public boolean equals(Money money) {
        if (this.currency().eq(money.currency())) {
            return this.value() == money.value();
        }
        if (conversionType == ConversionType.BaseCurrencyConversion) {
            Money tmp1 = this.clone();
            tmp1.convertToBase();
            Money tmp2 = money.clone();
            tmp2.convertToBase();
            return tmp1.equals(tmp2);
        }
        if (conversionType == ConversionType.AutomatedConversion) {
            Money tmp = money.clone();
            tmp.convertTo(this.currency());
            return this.equals(tmp);
        }
        throw new LibraryException("currency mismatch and no conversion specified");
    }

    public boolean less(Money money) {
        if (this.currency().eq(money.currency())) {
            return this.value() < money.value();
        }
        if (conversionType == ConversionType.BaseCurrencyConversion) {
            Money tmp1 = this.clone();
            tmp1.convertToBase();
            Money tmp2 = money;
            tmp2.convertToBase();
            return tmp1.less(tmp2);
        }
        if (conversionType == ConversionType.AutomatedConversion) {
            Money tmp = money;
            tmp.convertTo(this.currency());
            return this.less(tmp);
        }
        throw new LibraryException("currency mismatch and no conversion specified");
    }

    public boolean lessEquals(Money money) {
        if (this.currency().eq(money.currency())) {
            return this.value() <= money.value();
        }
        if (conversionType == ConversionType.BaseCurrencyConversion) {
            Money tmp1 = this.clone();
            tmp1.convertToBase();
            Money tmp2 = money;
            tmp2.convertToBase();
            return tmp1.less(tmp2);
        }
        if (conversionType == ConversionType.AutomatedConversion) {
            Money tmp = money.clone();
            tmp.convertTo(this.currency());
            return this.less(tmp);
        }
        throw new LibraryException("currency mismatch and no conversion specified");
    }

    public boolean close(Money money, int n) {
        if (this.currency().eq(money.currency())) {
            return Closeness.isClose(this.value(), money.value(), n);
        }
        if (conversionType == ConversionType.BaseCurrencyConversion) {
            Money tmp1 = this.clone();
            tmp1.convertToBase();
            Money tmp2 = money.clone();
            tmp2.convertToBase();
            return tmp1.close(tmp2, n);
        }
        if (conversionType == ConversionType.AutomatedConversion) {
            Money tmp = money.clone();
            tmp.convertTo(this.currency());
            return this.close(tmp, n);
        }
        throw new LibraryException("currency mismatch and no conversion specified");
    }

    public boolean close_enough(Money money, int n) {
        if (this.currency().eq(money.currency())) {
            return Closeness.isCloseEnough(this.value(), money.value(), n);
        }
        if (conversionType == ConversionType.BaseCurrencyConversion) {
            Money tmp1 = this.clone();
            tmp1.convertToBase();
            Money tmp2 = money;
            tmp2.convertToBase();
            return tmp1.close_enough(tmp2, n);
        }
        if (conversionType == ConversionType.AutomatedConversion) {
            Money tmp = money;
            tmp.convertTo(this.currency());
            return this.close_enough(tmp, n);
        }
        throw new LibraryException("currency mismatch and no conversion specified");
    }

    public String toString() {
        Currency currency = this.currency();
        return String.format(currency.format(), this.rounded().value_, currency.code(), currency.symbol());
    }

    public static enum ConversionType {
        NoConversion,
        BaseCurrencyConversion,
        AutomatedConversion;

    }
}

