/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.currencies;

import org.jquantlib.currencies.Currency;
import org.jquantlib.currencies.Money;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.util.Pair;

public class ExchangeRate {
    private Currency source_;
    private Currency target_;
    private double rate_;
    private Type type_;
    public Pair<ExchangeRate, ExchangeRate> rateChain_;

    public ExchangeRate() {
        this.rate_ = Double.MAX_VALUE;
    }

    public ExchangeRate(ExchangeRate toCopy) {
        this.source_ = toCopy.source_;
        this.target_ = toCopy.target_;
        this.rate_ = toCopy.rate_;
        this.type_ = toCopy.type_;
    }

    public ExchangeRate(Currency source, Currency target, double rate) {
        this.source_ = source;
        this.target_ = target;
        this.rate_ = rate;
        this.type_ = Type.Direct;
    }

    public Currency source() {
        return this.source_;
    }

    public Currency target() {
        return this.target_;
    }

    public Type type() {
        return this.type_;
    }

    public double rate() {
        return this.rate_;
    }

    public Money exchange(Money amount) {
        switch (this.type_) {
            case Direct: {
                if (amount.currency().eq(this.source_)) {
                    return new Money(amount.value() * this.rate_, this.target_);
                }
                if (amount.currency().eq(this.target_)) {
                    return new Money(amount.value() / this.rate_, this.source_);
                }
                throw new LibraryException("exchange rate not applicable");
            }
            case Derived: {
                if (amount.currency() == this.rateChain_.first().source() || amount.currency() == this.rateChain_.first().target()) {
                    return this.rateChain_.second().exchange(this.rateChain_.first().exchange(amount));
                }
                if (amount.currency() == this.rateChain_.second().source() || amount.currency() == this.rateChain_.second().target()) {
                    return this.rateChain_.first().exchange(this.rateChain_.second().exchange(amount));
                }
                throw new LibraryException("exchange rate not applicable");
            }
        }
        throw new LibraryException("unknown exchange-rate type");
    }

    public static ExchangeRate chain(ExchangeRate r1, ExchangeRate r2) {
        ExchangeRate result = new ExchangeRate();
        result.type_ = Type.Derived;
        result.rateChain_ = new Pair<ExchangeRate, ExchangeRate>(new ExchangeRate(r1), new ExchangeRate(r2));
        if (r1.source_.eq(r2.source_)) {
            result.source_ = r1.target_;
            result.target_ = r2.target_;
            result.rate_ = r2.rate_ / r1.rate_;
        } else if (r1.source_.eq(r2.target_)) {
            result.source_ = r1.target_;
            result.target_ = r2.source_;
            result.rate_ = 1.0 / (r1.rate_ * r2.rate_);
        } else if (r1.target_.eq(r2.source_)) {
            result.source_ = r1.source_;
            result.target_ = r2.target_;
            result.rate_ = r1.rate_ * r2.rate_;
        } else if (r1.target_.eq(r2.target_)) {
            result.source_ = r1.source_;
            result.target_ = r2.source_;
            result.rate_ = r1.rate_ / r2.rate_;
        } else {
            throw new LibraryException("exchange rates not chainable");
        }
        return result;
    }

    public static enum Type {
        Direct,
        Derived;

    }
}

