/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.currencies;

import org.jquantlib.math.Rounding;

public class Currency
implements Cloneable {
    protected Data data;

    public final String name() {
        return this.data.name;
    }

    public final String code() {
        return this.data.code;
    }

    public final int numericCode() {
        return this.data.numeric;
    }

    public final String symbol() {
        return this.data.symbol;
    }

    public final String fractionSymbol() {
        return this.data.fractionSymbol;
    }

    public final int fractionsPerUnit() {
        return this.data.fractionsPerUnit;
    }

    public final Rounding rounding() {
        return this.data.rounding;
    }

    public final String format() {
        return this.data.formatString;
    }

    public final boolean empty() {
        return this.data == null;
    }

    public final Currency triangulationCurrency() {
        return this.data.triangulated;
    }

    public final boolean eq(Currency currency) {
        return this.equals(currency);
    }

    public final boolean ne(Currency currency) {
        return !this.eq(currency);
    }

    public static final boolean operatorEquals(Currency c1, Currency c2) {
        return c1.equals(c2);
    }

    public static final boolean operatorNotEquals(Currency c1, Currency c2) {
        return !Currency.operatorEquals(c1, c2);
    }

    public String toString() {
        if (!this.empty()) {
            return this.code();
        }
        return "(null currency)";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return obj instanceof Currency && ((Currency)obj).fEquals(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        result = 31 * result + (this.data == null ? 0 : this.name().hashCode());
        return result;
    }

    protected boolean fEquals(Currency other) {
        if (this.empty() && other.empty()) {
            return true;
        }
        return this.name().equals(other.name());
    }

    protected Currency clone() {
        Currency currency = new Currency();
        if (this.data != null) {
            currency.data = this.data.clone();
        }
        return currency;
    }

    protected static class Data
    implements Cloneable {
        private final String name;
        private final String code;
        private final int numeric;
        private final String symbol;
        private final String fractionSymbol;
        private final int fractionsPerUnit;
        private final Rounding rounding;
        private final String formatString;
        private final Currency triangulated;

        public Data(String name, String code, int numericCode, String symbol, String fractionSymbol, int fractionsPerUnit, Rounding rounding, String formatString) {
            this(name, code, numericCode, symbol, fractionSymbol, fractionsPerUnit, rounding, formatString, new Currency());
        }

        public Data(String name, String code, int numericCode, String symbol, String fractionSymbol, int fractionsPerUnit, Rounding rounding, String formatString, Currency triangulationCurrency) {
            this.name = name;
            this.code = code;
            this.numeric = numericCode;
            this.symbol = symbol;
            this.fractionSymbol = fractionSymbol;
            this.fractionsPerUnit = fractionsPerUnit;
            this.rounding = rounding;
            this.triangulated = triangulationCurrency;
            this.formatString = formatString;
        }

        public Data clone() {
            Data data = new Data(this.name, this.code, this.numeric, this.symbol, this.fractionSymbol, this.fractionsPerUnit, this.rounding, this.formatString, this.triangulated.clone());
            return data;
        }
    }
}

