/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.cashflow;

import org.jquantlib.cashflow.BlackIborCouponPricer;
import org.jquantlib.cashflow.CappedFlooredIborCoupon;
import org.jquantlib.cashflow.FloatingLeg;
import org.jquantlib.cashflow.IborCoupon;
import org.jquantlib.cashflow.Leg;
import org.jquantlib.cashflow.PricerSetter;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.indexes.IborIndex;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.quotes.Handle;
import org.jquantlib.termstructures.volatilities.optionlet.OptionletVolatilityStructure;
import org.jquantlib.time.BusinessDayConvention;
import org.jquantlib.time.Schedule;

public class IborLeg {
    private final Schedule schedule_;
    private final IborIndex index_;
    private Array notionals_;
    private DayCounter paymentDayCounter_;
    private BusinessDayConvention paymentAdjustment_;
    private Array fixingDays_;
    private Array gearings_;
    private Array spreads_;
    private Array caps_;
    private Array floors_;
    private boolean inArrears_;
    private boolean zeroPayments_;

    public IborLeg(Schedule schedule, IborIndex index) {
        this.schedule_ = schedule;
        this.index_ = index;
        this.paymentAdjustment_ = BusinessDayConvention.Following;
        this.fixingDays_ = new Array(0);
        this.gearings_ = new Array(0);
        this.spreads_ = new Array(0);
        this.caps_ = new Array(0);
        this.floors_ = new Array(0);
        this.inArrears_ = false;
        this.zeroPayments_ = false;
    }

    public final IborLeg withNotionals(double notional) {
        this.notionals_ = new Array(new double[]{notional});
        return this;
    }

    public final IborLeg withNotionals(Array notionals) {
        this.notionals_ = notionals;
        return this;
    }

    public final IborLeg withPaymentDayCounter(DayCounter dayCounter) {
        this.paymentDayCounter_ = dayCounter;
        return this;
    }

    public final IborLeg withPaymentAdjustment(BusinessDayConvention convention) {
        this.paymentAdjustment_ = convention;
        return this;
    }

    public final IborLeg withFixingDays(double fixingDays) {
        this.fixingDays_ = new Array(new double[]{fixingDays});
        return this;
    }

    public final IborLeg withFixingDays(Array fixingDays) {
        this.fixingDays_ = fixingDays;
        return this;
    }

    public IborLeg withGearings(double gearing) {
        this.gearings_ = new Array(new double[]{gearing});
        return this;
    }

    public IborLeg withGearings(Array gearings) {
        this.gearings_ = gearings;
        return this;
    }

    public IborLeg withSpreads(double spread) {
        this.spreads_ = new Array(new double[]{spread});
        return this;
    }

    public IborLeg withSpreads(Array spreads) {
        this.spreads_ = spreads;
        return this;
    }

    public IborLeg withCaps(double cap) {
        this.caps_ = new Array(1).fill(cap);
        return this;
    }

    public IborLeg withCaps(Array caps) {
        this.caps_ = caps;
        return this;
    }

    public IborLeg withFloors(double floor) {
        this.floors_ = new Array(1).fill(floor);
        return this;
    }

    public IborLeg withFloors(Array floors) {
        this.floors_ = floors;
        return this;
    }

    public IborLeg inArrears(boolean flag) {
        this.inArrears_ = flag;
        return this;
    }

    public IborLeg withZeroPayments(boolean flag) {
        this.zeroPayments_ = flag;
        return this;
    }

    public Leg Leg() {
        FloatingLeg cashflows = new FloatingLeg(IborIndex.class, IborCoupon.class, CappedFlooredIborCoupon.class, this.notionals_, this.schedule_, this.index_, this.paymentDayCounter_, this.paymentAdjustment_, this.fixingDays_, this.gearings_, this.spreads_, this.caps_, this.floors_, this.inArrears_, this.zeroPayments_);
        if (this.caps_.empty() && this.floors_.empty() && !this.inArrears_) {
            PricerSetter.setCouponPricer(cashflows, new BlackIborCouponPricer(new Handle<OptionletVolatilityStructure>()));
        }
        return cashflows;
    }
}

