/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.cashflow;

import org.jquantlib.cashflow.CashFlow;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.time.Date;
import org.jquantlib.util.PolymorphicVisitor;
import org.jquantlib.util.Visitor;

public abstract class Coupon
extends CashFlow {
    protected double nominal;
    protected Date paymentDate_;
    protected Date accrualStartDate_;
    protected Date accrualEndDate_;
    protected Date refPeriodStart_;
    protected Date refPeriodEnd_;

    public Coupon(double nominal, Date paymentDate, Date accrualStartDate, Date accrualEndDate) {
        this(nominal, paymentDate, accrualStartDate, accrualEndDate, new Date(), new Date());
    }

    public Coupon(double nominal, Date paymentDate, Date accrualStartDate, Date accrualEndDate, Date refPeriodStart, Date refPeriodEnd) {
        this.nominal = nominal;
        this.paymentDate_ = paymentDate.clone();
        this.accrualStartDate_ = accrualStartDate.clone();
        this.accrualEndDate_ = accrualEndDate.clone();
        this.refPeriodStart_ = refPeriodStart.clone();
        this.refPeriodEnd_ = refPeriodEnd.clone();
    }

    public abstract double rate();

    public abstract DayCounter dayCounter();

    public abstract double accruedAmount(Date var1);

    public double nominal() {
        return this.nominal;
    }

    public Date accrualStartDate() {
        return this.accrualStartDate_;
    }

    public Date accrualEndDate() {
        return this.accrualEndDate_;
    }

    public Date referencePeriodStart() {
        return this.refPeriodStart_;
    }

    public Date referencePeriodEnd() {
        return this.refPeriodEnd_;
    }

    public double accrualPeriod() {
        return this.dayCounter().yearFraction(this.accrualStartDate_, this.accrualEndDate_, this.refPeriodStart_, this.refPeriodEnd_);
    }

    public long accrualDays() {
        return this.dayCounter().dayCount(this.accrualStartDate_, this.accrualEndDate_);
    }

    @Override
    public Date date() {
        return this.paymentDate_.clone();
    }

    @Override
    public void accept(PolymorphicVisitor pv) {
        Visitor<?> v;
        Visitor<?> visitor = v = pv != null ? pv.visitor(this.getClass()) : null;
        if (v != null) {
            v.visit(this);
        } else {
            super.accept(pv);
        }
    }
}

