/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.cashflow;

import org.jquantlib.QL;
import org.jquantlib.Settings;
import org.jquantlib.cashflow.FloatingRateCoupon;
import org.jquantlib.cashflow.IborCoupon;
import org.jquantlib.cashflow.IborCouponPricer;
import org.jquantlib.indexes.InterestRateIndex;
import org.jquantlib.instruments.Option;
import org.jquantlib.pricingengines.BlackFormula;
import org.jquantlib.quotes.Handle;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.termstructures.volatilities.optionlet.OptionletVolatilityStructure;
import org.jquantlib.time.Date;

public class BlackIborCouponPricer
extends IborCouponPricer {
    private static final String missing_caplet_volatility = "missing caplet volatility";
    private IborCoupon coupon_;
    private double discount_;
    private double gearing_;
    private double spread_;
    private double spreadLegValue_;

    public BlackIborCouponPricer(Handle<OptionletVolatilityStructure> capletVol) {
        super(capletVol);
    }

    @Override
    public void initialize(FloatingRateCoupon coupon) {
        this.coupon_ = (IborCoupon)coupon;
        this.gearing_ = this.coupon_.gearing();
        this.spread_ = this.coupon_.spread();
        Date paymentDate = this.coupon_.date();
        InterestRateIndex index = this.coupon_.index();
        Handle<YieldTermStructure> rateCurve = index.termStructure();
        Date today = new Settings().evaluationDate();
        this.discount_ = paymentDate.gt(today) ? rateCurve.currentLink().discount(paymentDate) : 1.0;
        this.spreadLegValue_ = this.spread_ * this.coupon_.accrualPeriod() * this.discount_;
    }

    @Override
    public double swapletPrice() {
        double swapletPrice = this.adjustedFixing() * this.coupon_.accrualPeriod() * this.discount_;
        return this.gearing_ * swapletPrice + this.spreadLegValue_;
    }

    @Override
    public double swapletRate() {
        return this.swapletPrice() / (this.coupon_.accrualPeriod() * this.discount_);
    }

    @Override
    public double capletPrice(double effectiveCap) {
        double capletPrice = this.optionletPrice(Option.Type.Call, effectiveCap);
        return this.gearing_ * capletPrice;
    }

    @Override
    public double capletRate(double effectiveCap) {
        return this.capletPrice(effectiveCap) / (this.coupon_.accrualPeriod() * this.discount_);
    }

    @Override
    public double floorletPrice(double effectiveFloor) {
        double floorletPrice = this.optionletPrice(Option.Type.Put, effectiveFloor);
        return this.gearing_ * floorletPrice;
    }

    @Override
    public double floorletRate(double effectiveFloor) {
        return this.floorletPrice(effectiveFloor) / (this.coupon_.accrualPeriod() * this.discount_);
    }

    public double optionletPrice(Option.Type optionType, double effStrike) {
        Date fixingDate = this.coupon_.fixingDate();
        if (fixingDate.le(new Settings().evaluationDate())) {
            double b;
            double a;
            if (optionType == Option.Type.Call) {
                a = this.coupon_.indexFixing();
                b = effStrike;
            } else {
                a = effStrike;
                b = this.coupon_.indexFixing();
            }
            return Math.max(a - b, 0.0) * this.coupon_.accrualPeriod() * this.discount_;
        }
        QL.require(this.capletVolatility() != null, missing_caplet_volatility);
        double fixing = BlackFormula.blackFormula(optionType, effStrike, this.adjustedFixing(), Math.sqrt(this.capletVolatility().currentLink().blackVariance(fixingDate, effStrike)));
        return fixing * this.coupon_.accrualPeriod() * this.discount_;
    }

    public double adjustedFixing() {
        double adjustement = 0.0;
        double fixing = this.coupon_.indexFixing();
        if (!this.coupon_.isInArrears()) {
            adjustement = 0.0;
        } else {
            QL.require(this.capletVolatility() != null, missing_caplet_volatility);
            Date d1 = this.coupon_.fixingDate();
            Date referenceDate = this.capletVolatility().currentLink().referenceDate();
            if (d1.le(referenceDate)) {
                adjustement = 0.0;
            } else {
                Date d2 = this.coupon_.index().maturityDate(d1);
                double tau = this.coupon_.index().dayCounter().yearFraction(d1, d2);
                double variance = this.capletVolatility().currentLink().blackVariance(d1, fixing);
                adjustement = fixing * fixing * variance * tau / (1.0 + fixing * tau);
            }
        }
        return fixing + adjustement;
    }
}

