/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.physics.feyncalc;

import cc.redberry.core.context.CC;
import cc.redberry.core.context.NameAndStructureOfIndices;
import cc.redberry.core.graph.GraphType;
import cc.redberry.core.graph.PrimitiveSubgraph;
import cc.redberry.core.graph.PrimitiveSubgraphPartition;
import cc.redberry.core.indices.IndexType;
import cc.redberry.core.indices.IndicesFactory;
import cc.redberry.core.indices.IndicesUtils;
import cc.redberry.core.number.Complex;
import cc.redberry.core.parser.ParseToken;
import cc.redberry.core.parser.ParseTokenTransformer;
import cc.redberry.core.parser.ParseUtils;
import cc.redberry.core.parser.Parser;
import cc.redberry.core.parser.preprocessor.ChangeIndicesTypesAndTensorNames;
import cc.redberry.core.parser.preprocessor.TypesAndNamesTransformer;
import cc.redberry.core.tensor.Expression;
import cc.redberry.core.tensor.Product;
import cc.redberry.core.tensor.ProductBuilder;
import cc.redberry.core.tensor.ProductContent;
import cc.redberry.core.tensor.SimpleTensor;
import cc.redberry.core.tensor.SumBuilder;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.Tensors;
import cc.redberry.core.tensor.iterator.FromChildToParentIterator;
import cc.redberry.core.transformations.ExpandAndEliminateTransformation;
import cc.redberry.core.transformations.Transformation;
import cc.redberry.core.utils.IntArrayList;
import cc.redberry.physics.feyncalc.LeviCivitaSimplifyTransformation;
import cc.redberry.physics.feyncalc.TraceUtils;
import gnu.trove.map.hash.TIntObjectHashMap;

public class DiracTraceTransformation
implements Transformation {
    private static final String gammaMatrixStringName = "G";
    private static final String gamma5StringName = "G5";
    private static final String leviCivitaStringName = "eps";
    private final int gammaName;
    private final int gamma5Name;
    private final IndexType metricType;
    private final IndexType matrixType;
    private final LeviCivitaSimplifyTransformation simplifyLeviCivita;
    private final ParseTokenTransformer tokenTransformer;
    private final Expression deltaTrace;
    private final TIntObjectHashMap<Expression> cachedSubstitutions = new TIntObjectHashMap();
    private static TIntObjectHashMap<ParseToken> cachedRawGammaTraces = new TIntObjectHashMap();
    private Transformation traceOf4GammasWith5;
    private Transformation chiholmKahaneIdentity;
    private static final Parser parser = CC.current().getParseManager().getParser();
    private static final ParseToken traceOf4GammasWith5Token = parser.parse("G_a^a'_b'*G_b^b'_c'*G_c^c'_d'*G_d^d'_e'*G5^e'_a' = -4*I*eps_abcd");
    private static final ParseToken chiholmKahaneToken = parser.parse("G_a^a'_c'*G_b^c'_d'*G_c^d'_b' = g_ab*G_c^a'_b'-g_ac*G_b^a'_b'+g_bc*G_a^a'_b'-I*e_abcd*G5^a'_c'*G^dc'_b'");

    public DiracTraceTransformation(final SimpleTensor gammaMatrix) {
        DiracTraceTransformation.checkNotation(gammaMatrix);
        this.gammaName = gammaMatrix.getName();
        this.gamma5Name = Integer.MIN_VALUE;
        IndexType[] types = TraceUtils.extractTypesFromMatrix(gammaMatrix);
        this.metricType = types[0];
        this.matrixType = types[1];
        this.tokenTransformer = new ChangeIndicesTypesAndTensorNames(new TypesAndNamesTransformer(){

            @Override
            public IndexType newType(IndexType oldType, NameAndStructureOfIndices oldDescriptor) {
                switch (oldType) {
                    case LatinLower: {
                        return DiracTraceTransformation.this.metricType;
                    }
                    case Matrix1: {
                        return DiracTraceTransformation.this.matrixType;
                    }
                }
                return oldType;
            }

            @Override
            public String newName(NameAndStructureOfIndices oldDescriptor) {
                switch (oldDescriptor.getName()) {
                    case "G": {
                        return gammaMatrix.getStringName();
                    }
                    case "G5": {
                        throw new IllegalArgumentException("Gamma5 is not specified.");
                    }
                    case "eps": {
                        throw new IllegalArgumentException("Levi-Civita is not specified.");
                    }
                }
                return oldDescriptor.getName();
            }
        });
        this.simplifyLeviCivita = null;
        this.deltaTrace = (Expression)this.tokenTransformer.transform(CC.current().getParseManager().getParser().parse("d^a_a=4")).toTensor();
    }

    public DiracTraceTransformation(SimpleTensor gammaMatrix, SimpleTensor gamma5, SimpleTensor leviCivita) {
        this(gammaMatrix, gamma5, leviCivita, true);
    }

    public DiracTraceTransformation(final SimpleTensor gammaMatrix, final SimpleTensor gamma5, final SimpleTensor leviCivita, boolean minkowskiSpace) {
        DiracTraceTransformation.checkNotation(gammaMatrix, gamma5, leviCivita);
        this.gammaName = gammaMatrix.getName();
        this.gamma5Name = gamma5.getName();
        IndexType[] types = TraceUtils.extractTypesFromMatrix(gammaMatrix);
        this.metricType = types[0];
        this.matrixType = types[1];
        this.tokenTransformer = new ChangeIndicesTypesAndTensorNames(new TypesAndNamesTransformer(){

            @Override
            public IndexType newType(IndexType oldType, NameAndStructureOfIndices oldDescriptor) {
                switch (oldType) {
                    case LatinLower: {
                        return DiracTraceTransformation.this.metricType;
                    }
                    case Matrix1: {
                        return DiracTraceTransformation.this.matrixType;
                    }
                }
                return oldType;
            }

            @Override
            public String newName(NameAndStructureOfIndices oldDescriptor) {
                switch (oldDescriptor.getName()) {
                    case "G": {
                        return gammaMatrix.getStringName();
                    }
                    case "G5": {
                        return gamma5.getStringName();
                    }
                    case "eps": {
                        return leviCivita.getStringName();
                    }
                }
                return oldDescriptor.getName();
            }
        });
        this.simplifyLeviCivita = new LeviCivitaSimplifyTransformation(leviCivita, minkowskiSpace);
        this.deltaTrace = (Expression)this.tokenTransformer.transform(CC.current().getParseManager().getParser().parse("d^a_a=4")).toTensor();
    }

    @Override
    public Tensor transform(Tensor tensor) {
        Tensor current;
        tensor = ExpandAndEliminateTransformation.expandAndEliminate(tensor);
        FromChildToParentIterator iterator = new FromChildToParentIterator(tensor);
        block0: while ((current = iterator.next()) != null) {
            if (this.isGammaOrGamma5(current) && current.getIndices().getFree().size(this.matrixType) == 0) {
                iterator.set(Complex.ZERO);
                continue;
            }
            if (!(current instanceof Product) || current.getIndices().getFree().size(this.matrixType) != 0) continue;
            boolean needTrace = false;
            for (Tensor t : current) {
                if (!this.isGammaOrGamma5(t)) continue;
                needTrace = true;
                break;
            }
            if (!needTrace) continue;
            Product product = (Product)current;
            IntArrayList positionsOfMatrices = new IntArrayList();
            int sizeOfIndexless = product.sizeOfIndexlessPart();
            ProductContent pc = product.getContent();
            PrimitiveSubgraph[] partition = PrimitiveSubgraphPartition.calculatePartition(pc, this.matrixType);
            ProductBuilder traces = new ProductBuilder();
            block2: for (PrimitiveSubgraph subgraph : partition) {
                if (subgraph.getGraphType() != GraphType.Cycle) continue;
                int numberOfGammas = 0;
                int numberOfGamma5s = 0;
                int[] positions = subgraph.getPartition();
                assert (positions.length > 1);
                for (int i = positions.length - 1; i >= 0; --i) {
                    positions[i] = positions[i] + sizeOfIndexless;
                    Tensor gamma = product.get(positions[i]);
                    if (!(gamma instanceof SimpleTensor)) continue block2;
                    if (((SimpleTensor)gamma).getName() == this.gammaName) {
                        ++numberOfGammas;
                        continue;
                    }
                    if (((SimpleTensor)gamma).getName() != this.gamma5Name) continue block2;
                    ++numberOfGamma5s;
                }
                if (numberOfGammas % 2 == 1 || numberOfGammas == 2 && numberOfGamma5s % 2 == 1) {
                    iterator.set(Complex.ZERO);
                    continue block0;
                }
                if (numberOfGammas == 0 && numberOfGamma5s % 2 == 1) {
                    iterator.set(Complex.ZERO);
                    continue block0;
                }
                positionsOfMatrices.addAll(positions);
                if (numberOfGamma5s == 0) {
                    traces.put(this.traceWithout5(product.select(positions), numberOfGammas));
                    continue;
                }
                if (numberOfGammas == 0) {
                    traces.put(Complex.FOUR);
                    continue;
                }
                if (numberOfGamma5s > 1) {
                    boolean sign = false;
                    Tensor[] orderedProduct = new SimpleTensor[numberOfGammas + (numberOfGamma5s % 2 == 0 ? 0 : 1)];
                    int counter = -1;
                    int positionOfPreviousGamma = -2;
                    for (int positionOfGamma = 0; positionOfGamma < positions.length; ++positionOfGamma) {
                        SimpleTensor currentGamma = (SimpleTensor)product.get(positions[positionOfGamma]);
                        if (currentGamma.getName() == this.gamma5Name) {
                            if (positionOfPreviousGamma == -2) {
                                if (numberOfGamma5s % 2 == 1) {
                                    orderedProduct[++counter] = currentGamma;
                                    positionOfPreviousGamma = -1;
                                    continue;
                                }
                                positionOfPreviousGamma = positionOfGamma;
                                continue;
                            }
                            if (positionOfPreviousGamma == -1) {
                                positionOfPreviousGamma = positionOfGamma;
                                continue;
                            }
                            if ((positionOfGamma - positionOfPreviousGamma) % 2 == 0) {
                                sign ^= true;
                            }
                            positionOfPreviousGamma = -1;
                            continue;
                        }
                        orderedProduct[++counter] = currentGamma;
                    }
                    int u = 0;
                    int l = 0;
                    int i = 0;
                    while (true) {
                        if (i == orderedProduct.length - 1) break;
                        orderedProduct[i] = this.setMatrixIndices(orderedProduct[i], u, ++l);
                        u = l;
                        ++i;
                    }
                    orderedProduct[i] = this.setMatrixIndices(orderedProduct[i], u, 0);
                    Tensor withoutExcessGamma5s = Tensors.multiply(orderedProduct);
                    if (numberOfGamma5s % 2 == 0) {
                        withoutExcessGamma5s = this.traceWithout5(withoutExcessGamma5s, numberOfGammas);
                    } else {
                        withoutExcessGamma5s = this.traceWith5(withoutExcessGamma5s, numberOfGammas);
                        withoutExcessGamma5s = this.simplifyLeviCivita.transform(withoutExcessGamma5s);
                    }
                    if (sign) {
                        withoutExcessGamma5s = Tensors.negate(withoutExcessGamma5s);
                    }
                    traces.put(withoutExcessGamma5s);
                    continue;
                }
                traces.put(this.traceWith5(product.select(positions), numberOfGammas));
            }
            if (positionsOfMatrices.isEmpty()) continue;
            traces.put(product.remove(positionsOfMatrices.toArray()));
            current = traces.build();
            current = ExpandAndEliminateTransformation.expandAndEliminate(current);
            current = this.deltaTrace.transform(current);
            if (this.simplifyLeviCivita != null) {
                current = this.simplifyLeviCivita.transform(current);
            }
            iterator.set(current);
        }
        return iterator.result();
    }

    private SimpleTensor setMatrixIndices(SimpleTensor gamma, int matrixUpper, int matrixLower) {
        int[] indices = gamma.getIndices().getAllIndices().copy();
        for (int i = indices.length - 1; i >= 0; --i) {
            if (CC.isMetric(IndicesUtils.getType(indices[i]))) continue;
            indices[i] = IndicesUtils.getState(indices[i]) ? IndicesUtils.createIndex(matrixUpper, IndicesUtils.getType(indices[i]), IndicesUtils.getState(indices[i])) : IndicesUtils.setType(IndicesUtils.getType(indices[i]), matrixLower);
        }
        return Tensors.simpleTensor(gamma.getName(), IndicesFactory.createSimple(null, indices));
    }

    private boolean isGammaOrGamma5(Tensor tensor) {
        if (tensor instanceof SimpleTensor) {
            int name = ((SimpleTensor)tensor).getName();
            if (name == this.gammaName) {
                return true;
            }
            if (name == this.gamma5Name) {
                return this.simplifyLeviCivita != null;
            }
        }
        return false;
    }

    private Tensor traceWithout5(Tensor tensor, int numberOfGammas) {
        Expression substitution = (Expression)this.cachedSubstitutions.get(numberOfGammas);
        if (substitution == null) {
            ParseToken rawSubstitution = DiracTraceTransformation.createRawGammaSubstitution(numberOfGammas);
            substitution = (Expression)this.tokenTransformer.transform(rawSubstitution).toTensor();
            this.cachedSubstitutions.put(numberOfGammas, (Object)substitution);
        }
        tensor = substitution.transform(tensor);
        tensor = ExpandAndEliminateTransformation.expandAndEliminate(tensor);
        tensor = this.deltaTrace.transform(tensor);
        return tensor;
    }

    private static ParseToken createRawGammaSubstitution(int numberOfGammas) {
        ParseToken substitution = (ParseToken)cachedRawGammaTraces.get(numberOfGammas);
        if (substitution == null) {
            int firstUpper;
            Tensor[] gammas = new Tensor[numberOfGammas];
            int matrixIndex = IndicesUtils.setType(IndexType.Matrix1, 0) - 1;
            int metricIndex = -1;
            int u = firstUpper = ++matrixIndex;
            for (int i = 0; i < numberOfGammas; ++i) {
                gammas[i] = Tensors.simpleTensor(gammaMatrixStringName, IndicesFactory.createSimple(null, u | Integer.MIN_VALUE, i == numberOfGammas - 1 ? firstUpper : ++matrixIndex, ++metricIndex));
            }
            Expression expression = Tensors.expression(Tensors.multiply(gammas), DiracTraceTransformation.traceOfArray(gammas));
            substitution = ParseUtils.tensor2AST(expression);
            cachedRawGammaTraces.put(numberOfGammas, (Object)substitution);
        }
        return substitution;
    }

    private static Tensor traceOfArray(Tensor[] product) {
        if (product.length == 1) {
            return Complex.ZERO;
        }
        if (product.length == 2) {
            return Tensors.multiply(Complex.FOUR, Tensors.createMetricOrKronecker(product[0].getIndices().get(IndexType.LatinLower, 0), product[1].getIndices().get(IndexType.LatinLower, 0)));
        }
        if (product.length % 2 != 0) {
            return Complex.ZERO;
        }
        SumBuilder sb = new SumBuilder();
        for (int i = 0; i < product.length - 1; ++i) {
            Tensor temp = Tensors.multiply(Complex.TWO, Tensors.createMetricOrKronecker(product[i].getIndices().get(IndexType.LatinLower, 0), product[i + 1].getIndices().get(IndexType.LatinLower, 0)), DiracTraceTransformation.traceOfArray(DiracTraceTransformation.subArray(product, i, i + 1)));
            if (i % 2 != 0) {
                temp = Tensors.negate(temp);
            }
            sb.put(temp);
            DiracTraceTransformation.swap(product, i, i + 1);
        }
        return Tensors.multiply(Complex.ONE_HALF, sb.build());
    }

    private static Tensor[] subArray(Tensor[] array, int a, int b) {
        Tensor[] result = new Tensor[array.length - 2];
        int k = 0;
        for (int i = 0; i < array.length; ++i) {
            if (i == a || i == b) continue;
            result[k++] = array[i];
        }
        return result;
    }

    private static void swap(Tensor[] array, int a, int b) {
        Tensor temp = array[a];
        array[a] = array[b];
        array[b] = temp;
    }

    public static void resetCache() {
        cachedRawGammaTraces = new TIntObjectHashMap();
    }

    private Tensor traceWith5(Tensor product, int numberOfGammas) {
        if (this.traceOf4GammasWith5 == null) {
            this.traceOf4GammasWith5 = (Expression)this.tokenTransformer.transform(traceOf4GammasWith5Token).toTensor();
            this.chiholmKahaneIdentity = (Expression)this.tokenTransformer.transform(chiholmKahaneToken).toTensor();
        }
        if (numberOfGammas == 4) {
            return this.traceOf4GammasWith5.transform(product);
        }
        product = this.chiholmKahaneIdentity.transform(product);
        product = ExpandAndEliminateTransformation.expandAndEliminate(product);
        product = this.traceOf4GammasWith5.transform(product);
        product = this.simplifyLeviCivita.transform(product);
        return this.transform(product);
    }

    private static final void checkNotation(SimpleTensor gammaMatrix) {
        IndexType[] types = TraceUtils.extractTypesFromMatrix(gammaMatrix);
        IndexType metricType = types[0];
        IndexType matrixType = types[1];
        if (gammaMatrix.getIndices().size() != 3 || gammaMatrix.getIndices().size(metricType) != 1 || gammaMatrix.getIndices().size(matrixType) != 2) {
            throw new IllegalArgumentException("Not a gamma: " + gammaMatrix);
        }
    }

    private static final void checkNotation(SimpleTensor gammaMatrix, SimpleTensor gamma5Matrix, SimpleTensor leviCivita) {
        IndexType[] types = TraceUtils.extractTypesFromMatrix(gammaMatrix);
        IndexType metricType = types[0];
        IndexType matrixType = types[1];
        if (gammaMatrix.getIndices().size() != 3 || gammaMatrix.getIndices().size(metricType) != 1 || gammaMatrix.getIndices().size(matrixType) != 2) {
            throw new IllegalArgumentException("Not a gamma: " + gammaMatrix);
        }
        if (gamma5Matrix.getIndices().size() != 2 || gamma5Matrix.getIndices().size(matrixType) != 2) {
            throw new IllegalArgumentException("Not a gamma5: " + gamma5Matrix);
        }
        if (leviCivita.getIndices().size() != 4 || leviCivita.getIndices().size(metricType) != 4) {
            throw new IllegalArgumentException("Not a Levi-Civita: " + leviCivita);
        }
    }
}

