/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.utils;

import cc.redberry.core.context.CC;
import cc.redberry.core.indices.IndexType;
import cc.redberry.core.indices.IndicesUtils;
import cc.redberry.core.indices.SimpleIndices;
import cc.redberry.core.tensor.SimpleTensor;

public final class MatrixUtils {
    private MatrixUtils() {
    }

    public static boolean isGeneralizedMatrix(SimpleTensor tensor, IndexType type, int upper, int lower) {
        int i;
        if (CC.isMetric(type)) {
            throw new IllegalArgumentException("Matrices can not be of metric type.");
        }
        SimpleIndices indices = tensor.getIndices().getOfType(type);
        for (i = 0; i < upper; ++i) {
            if (IndicesUtils.getState(indices.get(i))) continue;
            return false;
        }
        upper += lower;
        while (i < upper) {
            if (IndicesUtils.getState(indices.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isMatrix(SimpleTensor tensor, IndexType type) {
        return MatrixUtils.isGeneralizedMatrix(tensor, type, 1, 1);
    }

    public static boolean isVector(SimpleTensor tensor, IndexType type) {
        return MatrixUtils.isGeneralizedMatrix(tensor, type, 1, 0);
    }

    public static boolean isCovector(SimpleTensor tensor, IndexType type) {
        return MatrixUtils.isGeneralizedMatrix(tensor, type, 0, 1);
    }
}

