/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.substitutions;

import cc.redberry.core.indexmapping.IndexMappings;
import cc.redberry.core.indexmapping.Mapping;
import cc.redberry.core.indices.IndicesBuilder;
import cc.redberry.core.indices.IndicesUtils;
import cc.redberry.core.number.Complex;
import cc.redberry.core.tensor.ApplyIndexMapping;
import cc.redberry.core.tensor.Product;
import cc.redberry.core.tensor.ProductBuilder;
import cc.redberry.core.tensor.ProductContent;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.Tensors;
import cc.redberry.core.transformations.substitutions.IndexlessBijectionsPort;
import cc.redberry.core.transformations.substitutions.PrimitiveSubstitution;
import cc.redberry.core.transformations.substitutions.ProductsBijectionsPort;
import cc.redberry.core.transformations.substitutions.SubstitutionIterator;
import cc.redberry.core.utils.TensorUtils;
import gnu.trove.TIntCollection;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Arrays;

class PrimitiveProductSubstitution
extends PrimitiveSubstitution {
    private final Complex fromFactor;
    private final Tensor[] fromIndexless;
    private final Tensor[] fromData;
    private final ProductContent fromContent;

    public PrimitiveProductSubstitution(Tensor from, Tensor to) {
        super(from, to);
        Product product = (Product)from;
        this.fromFactor = product.getFactor();
        this.fromIndexless = product.getIndexless();
        this.fromContent = product.getContent();
        this.fromData = this.fromContent.getDataCopy();
    }

    @Override
    Tensor newTo_(Tensor currentNode, SubstitutionIterator iterator) {
        ForbiddenContainer forbidden;
        Product product = (Product)currentNode;
        Complex factor = product.getFactor();
        PContent content = new PContent(product.getIndexless(), product.getDataSubProduct());
        SubsResult subsResult = this.atomicSubstitute(content, forbidden = new ForbiddenContainer(), iterator);
        if (subsResult == null) {
            return currentNode;
        }
        ArrayList<Tensor> newTos = new ArrayList<Tensor>();
        while (subsResult != null) {
            factor = factor.divide(this.fromFactor);
            newTos.add(subsResult.newTo);
            content = subsResult.remainder;
            subsResult = this.atomicSubstitute(content, forbidden, iterator);
        }
        Tensor[] result = new Tensor[newTos.size() + content.indexless.length + 2];
        System.arraycopy(newTos.toArray(new Tensor[newTos.size()]), 0, result, 0, newTos.size());
        System.arraycopy(content.indexless, 0, result, newTos.size(), content.indexless.length);
        result[result.length - 2] = content.data;
        result[result.length - 1] = factor;
        return Tensors.multiply(result);
    }

    SubsResult atomicSubstitute(PContent content, ForbiddenContainer forbidden, SubstitutionIterator iterator) {
        Tensor newTo;
        int i;
        int[] dataBijection;
        Tensor[] currentData;
        int[] indexlessBijection;
        Mapping mapping = null;
        IndexlessBijectionsPort indexlessPort = new IndexlessBijectionsPort(this.fromIndexless, content.indexless);
        while ((indexlessBijection = indexlessPort.take()) != null && (mapping = IndexMappings.createBijectiveProductPort(this.fromIndexless, PrimitiveProductSubstitution.extract(content.indexless, indexlessBijection)).take()) == null) {
        }
        if (mapping == null) {
            return null;
        }
        boolean sign = mapping.getSign();
        mapping = null;
        if (content.data instanceof Product) {
            ProductContent currentContent = ((Product)content.data).getContent();
            currentData = currentContent.getDataCopy();
            ProductsBijectionsPort dataPort = new ProductsBijectionsPort(this.fromContent, currentContent);
            while ((dataBijection = dataPort.take()) != null && (mapping = IndexMappings.createBijectiveProductPort(this.fromData, PrimitiveProductSubstitution.extract(currentData, dataBijection)).take()) == null) {
            }
        } else if (TensorUtils.isOne(content.data)) {
            if (this.fromContent.size() != 0) {
                return null;
            }
            dataBijection = new int[]{};
            currentData = new Tensor[]{};
            mapping = Mapping.IDENTITY;
        } else {
            if (this.fromContent.size() != 1) {
                return null;
            }
            dataBijection = new int[1];
            currentData = new Tensor[]{content.data};
            mapping = IndexMappings.getFirst(this.fromContent.get(0), content.data);
        }
        if (mapping == null) {
            return null;
        }
        mapping = mapping.addSign(sign);
        Arrays.sort(indexlessBijection);
        Arrays.sort(dataBijection);
        Tensor[] indexlessRemainder = new Tensor[content.indexless.length - this.fromIndexless.length];
        ProductBuilder dataRemainder = new ProductBuilder(0, content.data instanceof Product ? content.data.size() : 1 - this.fromContent.size());
        int pivot = 0;
        int j = 0;
        for (i = 0; i < content.indexless.length; ++i) {
            if (pivot < indexlessBijection.length && i == indexlessBijection[pivot]) {
                ++pivot;
                continue;
            }
            indexlessRemainder[j++] = content.indexless[i];
        }
        pivot = 0;
        for (i = 0; i < currentData.length; ++i) {
            if (pivot < dataBijection.length && i == dataBijection[pivot]) {
                ++pivot;
                continue;
            }
            dataRemainder.put(currentData[i]);
        }
        Tensor dataRemainderT = dataRemainder.build();
        PContent remainder = new PContent(indexlessRemainder, dataRemainderT);
        if (this.toIsSymbolic) {
            newTo = mapping.getSign() ? Tensors.negate(this.to) : this.to;
        } else if (this.possiblyAddsDummies) {
            if (forbidden.forbidden == null) {
                forbidden.forbidden = new TIntHashSet(iterator.getForbidden());
            }
            TIntHashSet remainderIndices = new TIntHashSet((TIntCollection)forbidden.forbidden);
            remainderIndices.addAll((TIntCollection)TensorUtils.getAllIndicesNamesT(indexlessRemainder));
            remainderIndices.addAll((TIntCollection)TensorUtils.getAllIndicesNamesT(dataRemainderT));
            newTo = ApplyIndexMapping.applyIndexMapping(this.to, mapping, remainderIndices.toArray());
            forbidden.forbidden.addAll((TIntCollection)TensorUtils.getAllIndicesNamesT(newTo));
        } else {
            TIntHashSet allowed = new TIntHashSet();
            for (int index : indexlessBijection) {
                allowed.addAll((TIntCollection)TensorUtils.getAllDummyIndicesT(content.indexless[index]));
            }
            IndicesBuilder ib = new IndicesBuilder();
            for (int index : dataBijection) {
                allowed.addAll((TIntCollection)TensorUtils.getAllDummyIndicesT(currentData[index]));
                ib.append(currentData[index]);
            }
            allowed.addAll(ib.getIndices().getNamesOfDummies());
            allowed.removeAll(IndicesUtils.getIndicesNames(mapping.getToData()));
            newTo = ApplyIndexMapping.applyIndexMappingAndRenameAllDummies(this.to, mapping, allowed.toArray());
        }
        return new SubsResult(newTo, remainder);
    }

    private static Tensor[] extract(Tensor[] source, int[] positions) {
        Tensor[] r = new Tensor[positions.length];
        for (int i = 0; i < positions.length; ++i) {
            r[i] = source[positions[i]];
        }
        return r;
    }

    private static final class PContent {
        final Tensor[] indexless;
        final Tensor data;

        private PContent(Tensor[] indexless, Tensor data) {
            this.indexless = indexless;
            this.data = data;
        }
    }

    private static final class SubsResult {
        final Tensor newTo;
        final PContent remainder;

        private SubsResult(Tensor newTo, PContent remainder) {
            this.newTo = newTo;
            this.remainder = remainder;
        }
    }

    private static final class ForbiddenContainer {
        TIntHashSet forbidden = null;

        private ForbiddenContainer() {
        }
    }
}

