/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.fractions;

import cc.redberry.core.number.Complex;
import cc.redberry.core.tensor.Power;
import cc.redberry.core.tensor.Product;
import cc.redberry.core.tensor.Sum;
import cc.redberry.core.tensor.SumBuilder;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.Tensors;
import cc.redberry.core.tensor.iterator.FromChildToParentIterator;
import cc.redberry.core.transformations.CollectScalarFactorsTransformation;
import cc.redberry.core.transformations.Transformation;
import cc.redberry.core.transformations.factor.FactorTransformation;
import cc.redberry.core.utils.THashMap;
import cc.redberry.core.utils.TensorUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class TogetherTransformation
implements Transformation {
    public static final TogetherTransformation TOGETHER = new TogetherTransformation();
    public static final TogetherTransformation TOGETHER_FACTOR = new TogetherTransformation(FactorTransformation.FACTOR);
    private final Transformation factor;

    public TogetherTransformation(Transformation factor) {
        this.factor = factor;
    }

    public TogetherTransformation() {
        this(null);
    }

    @Override
    public Tensor transform(Tensor t) {
        Tensor c;
        FromChildToParentIterator iterator = new FromChildToParentIterator(t);
        while ((c = iterator.next()) != null) {
            if (c instanceof Sum) {
                iterator.set(this.togetherSum(c));
            }
            if (!(c instanceof Product)) continue;
            iterator.set(CollectScalarFactorsTransformation.collectScalarFactorsInProduct((Product)c));
        }
        return iterator.result();
    }

    private Tensor togetherSum(Tensor t) {
        int i;
        boolean performTogether = false;
        block0: for (Tensor s : t) {
            if (s instanceof Product) {
                for (Tensor p : s) {
                    if (!TogetherTransformation.checkPower(p)) continue;
                    performTogether = true;
                    continue block0;
                }
                continue;
            }
            if (!TogetherTransformation.checkPower(s)) continue;
            performTogether = true;
            break;
        }
        if (!performTogether) {
            return t;
        }
        SplitStruct base = this.splitFraction(t.get(0));
        List[] numeratorTerms = new List[t.size()];
        numeratorTerms[0] = new ArrayList();
        numeratorTerms[0].add(base.numerator);
        for (i = 1; i < t.size(); ++i) {
            Complex _exponent;
            Tensor power;
            Complex exponent;
            Tensor s = t.get(i);
            SplitStruct temp = this.splitFraction(s);
            ArrayList<Tensor> newNumeratorTerm = new ArrayList<Tensor>();
            newNumeratorTerm.add(temp.numerator);
            numeratorTerms[i] = newNumeratorTerm;
            for (Map.Entry entry : base.denominators.entrySet()) {
                exponent = temp.denominators.get(entry.getKey());
                if (exponent == null) {
                    power = Tensors.pow((Tensor)entry.getKey(), (Tensor)entry.getValue());
                    newNumeratorTerm.add(power);
                    continue;
                }
                _exponent = ((Complex)entry.getValue()).subtract(exponent);
                if (_exponent.getReal().signum() <= 0) continue;
                power = Tensors.pow((Tensor)entry.getKey(), _exponent);
                newNumeratorTerm.add(power);
            }
            for (Map.Entry entry : temp.denominators.entrySet()) {
                int j;
                exponent = base.denominators.get(entry.getKey());
                if (exponent == null) {
                    power = Tensors.pow((Tensor)entry.getKey(), (Tensor)entry.getValue());
                    for (j = 0; j < i; ++j) {
                        numeratorTerms[j].add(power);
                    }
                    base.denominators.put((Tensor)entry.getKey(), (Complex)entry.getValue());
                    continue;
                }
                _exponent = ((Complex)entry.getValue()).subtract(exponent);
                if (_exponent.getReal().signum() <= 0) continue;
                power = Tensors.pow((Tensor)entry.getKey(), _exponent);
                for (j = 0; j < i; ++j) {
                    numeratorTerms[j].add(power);
                }
                base.denominators.put((Tensor)entry.getKey(), (Complex)entry.getValue());
            }
        }
        SumBuilder numeratorSumBuilder = new SumBuilder();
        for (List term : numeratorTerms) {
            numeratorSumBuilder.put(CollectScalarFactorsTransformation.collectScalarFactors(Tensors.multiplyAndRenameConflictingDummies(term.toArray(new Tensor[term.size()]))));
        }
        Tensor[] resultProduct = new Tensor[1 + base.denominators.size()];
        resultProduct[0] = numeratorSumBuilder.build();
        i = 0;
        for (Map.Entry<Tensor, Complex> baseEntry : base.denominators.entrySet()) {
            resultProduct[++i] = Tensors.pow(baseEntry.getKey(), baseEntry.getValue().negate());
        }
        return Tensors.multiplyAndRenameConflictingDummies(resultProduct);
    }

    private SplitStruct splitFraction(Tensor tensor) {
        if (this.factor != null) {
            tensor = this.factor.transform(tensor);
        }
        THashMap<Tensor, Complex> map = new THashMap<Tensor, Complex>();
        if (TogetherTransformation.checkPower(tensor)) {
            map.put(tensor.get(0), ((Complex)tensor.get(1)).negate());
            return new SplitStruct(map, Complex.ONE);
        }
        if (tensor instanceof Product) {
            Tensor product = tensor;
            Tensor temp = null;
            for (int i = tensor.size() - 1; i >= 0; --i) {
                Tensor m = tensor.get(i);
                if (!TogetherTransformation.checkPower(m)) continue;
                map.put(m.get(0), ((Complex)m.get(1)).negate());
                if (product instanceof Product) {
                    temp = product = ((Product)product).remove(i);
                    continue;
                }
                assert (i == 0);
                temp = Complex.ONE;
            }
            if (temp == null) {
                temp = tensor;
            }
            return new SplitStruct(map, temp);
        }
        return new SplitStruct(map, tensor);
    }

    private static boolean checkPower(Tensor power) {
        return power instanceof Power && TensorUtils.isRealNegativeNumber(power.get(1));
    }

    public static Tensor together(Tensor t) {
        return TOGETHER.transform(t);
    }

    public static Tensor together(Tensor t, Transformation factor) {
        return new TogetherTransformation(factor).transform(t);
    }

    public static Tensor together(Tensor t, boolean doFactor) {
        if (!doFactor) {
            return TogetherTransformation.together(t);
        }
        return TOGETHER_FACTOR.transform(t);
    }

    private static class SplitStruct {
        final THashMap<Tensor, Complex> denominators;
        final Tensor numerator;

        public SplitStruct(THashMap<Tensor, Complex> denominators, Tensor numerator) {
            this.denominators = denominators;
            this.numerator = numerator;
        }
    }
}

