/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.factor.jasfactor.edu.jas.util;

import cc.redberry.core.transformations.factor.jasfactor.edu.jas.util.CartesianOneProductInfiniteIterator;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.util.CartesianTwoProductInfiniteIteratorList;
import java.util.Iterator;
import java.util.List;

public class CartesianProductInfinite<E>
implements Iterable<List<E>> {
    public final List<Iterable<E>> comps;

    public CartesianProductInfinite(List<Iterable<E>> comps) {
        if (comps == null || comps.size() == 0) {
            throw new IllegalArgumentException("null components not allowed");
        }
        this.comps = comps;
    }

    @Override
    public Iterator<List<E>> iterator() {
        if (this.comps.size() == 1) {
            return new CartesianOneProductInfiniteIterator<E>(this.comps.get(0));
        }
        int n = this.comps.size();
        int k = n / 2 + n % 2;
        CartesianProductInfinite<E> c0 = new CartesianProductInfinite<E>(this.comps.subList(0, k));
        CartesianProductInfinite<E> c1 = new CartesianProductInfinite<E>(this.comps.subList(k, n));
        return new CartesianTwoProductInfiniteIteratorList(c0, c1);
    }
}

