/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd;

import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.GenPolynomial;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.PolyUtil;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.AbelianGroupElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.GcdRingElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.Power;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.RingFactory;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.GreatestCommonDivisorAbstract;

public class GreatestCommonDivisorSimple<C extends GcdRingElem<C>>
extends GreatestCommonDivisorAbstract<C> {
    @Override
    public GenPolynomial<C> baseGcd(GenPolynomial<C> P, GenPolynomial<C> S) {
        GcdRingElem c;
        AbelianGroupElem<GenPolynomial<GcdRingElem>> q;
        AbelianGroupElem<GenPolynomial<GcdRingElem>> r;
        if (S == null || S.isZERO()) {
            return P;
        }
        if (P == null || P.isZERO()) {
            return S;
        }
        if (P.ring.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " no univariate polynomial");
        }
        boolean field = P.ring.coFac.isField();
        long e = P.degree(0);
        long f = S.degree(0);
        if (f > e) {
            r = P;
            q = S;
            long g = f;
            f = e;
            e = g;
        } else {
            q = P;
            r = S;
        }
        if (field) {
            r = ((GenPolynomial)r).monic();
            q = ((GenPolynomial)q).monic();
            c = (GcdRingElem)P.ring.getONECoefficient();
        } else {
            r = ((GenPolynomial)r).abs();
            q = ((GenPolynomial)q).abs();
            C a = this.baseContent(r);
            C b = this.baseContent(q);
            c = this.gcd(a, b);
            r = this.divide(r, a);
            q = this.divide(q, b);
        }
        if (((GenPolynomial)r).isONE()) {
            return ((GenPolynomial)r).multiply((GenPolynomial<GcdRingElem>)((Object)c));
        }
        if (((GenPolynomial)q).isONE()) {
            return ((GenPolynomial)q).multiply((GenPolynomial<GcdRingElem>)((Object)c));
        }
        while (!((GenPolynomial)r).isZERO()) {
            GenPolynomial<GenPolynomial<C>> x = PolyUtil.baseSparsePseudoRemainder(q, r);
            q = r;
            if (field) {
                r = x.monic();
                continue;
            }
            r = x;
        }
        q = this.basePrimitivePart(q);
        return ((GenPolynomial)q).multiply((GenPolynomial<GcdRingElem>)((Object)c)).abs();
    }

    @Override
    public GenPolynomial<GenPolynomial<C>> recursiveUnivariateGcd(GenPolynomial<GenPolynomial<C>> P, GenPolynomial<GenPolynomial<C>> S) {
        AbelianGroupElem<GenPolynomial<Object>> q;
        AbelianGroupElem<GenPolynomial<Object>> r;
        if (S == null || S.isZERO()) {
            return P;
        }
        if (P == null || P.isZERO()) {
            return S;
        }
        if (P.ring.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " no univariate polynomial");
        }
        boolean field = P.leadingBaseCoefficient().ring.coFac.isField();
        long e = P.degree(0);
        long f = S.degree(0);
        if (f > e) {
            r = P;
            q = S;
            long g = f;
            f = e;
            e = g;
        } else {
            q = P;
            r = S;
        }
        if (field) {
            r = PolyUtil.monic(r);
            q = PolyUtil.monic(q);
        } else {
            r = ((GenPolynomial)r).abs();
            q = q.abs();
        }
        GenPolynomial<C> a = this.recursiveContent(r);
        GenPolynomial<C> b = this.recursiveContent(q);
        GenPolynomial<C> c = this.gcd(a, b);
        r = PolyUtil.recursiveDivide(r, a);
        q = PolyUtil.recursiveDivide(q, b);
        if (((GenPolynomial)r).isONE()) {
            return ((GenPolynomial)r).multiply(c);
        }
        if (q.isONE()) {
            return q.multiply(c);
        }
        while (!((GenPolynomial)r).isZERO()) {
            GenPolynomial x = PolyUtil.recursivePseudoRemainder(q, r);
            q = r;
            if (field) {
                r = PolyUtil.monic(x);
                continue;
            }
            r = x;
        }
        q = this.recursivePrimitivePart(q);
        q = ((GenPolynomial)q.abs()).multiply(c);
        return q;
    }

    @Override
    public GenPolynomial<C> baseResultant(GenPolynomial<C> P, GenPolynomial<C> S) {
        int i;
        GcdRingElem c2;
        GenPolynomial<Object> x;
        long g;
        GenPolynomial<C> q;
        GenPolynomial<C> r;
        if (S == null || S.isZERO()) {
            return S;
        }
        if (P == null || P.isZERO()) {
            return P;
        }
        if (P.ring.nvar > 1 || P.ring.nvar == 0) {
            throw new IllegalArgumentException("no univariate polynomial");
        }
        long e = P.degree(0);
        long f = S.degree(0);
        if (f == 0L && e == 0L) {
            return P.ring.getONE();
        }
        if (e == 0L) {
            return Power.power(P.ring, P, f);
        }
        if (f == 0L) {
            return Power.power(S.ring, S, e);
        }
        int s = 0;
        if (e < f) {
            r = P;
            q = S;
            long t = e;
            e = f;
            f = t;
            if (e % 2L != 0L && f % 2L != 0L) {
                s = 1;
            }
        } else {
            q = P;
            r = S;
        }
        RingFactory cofac = P.ring.coFac;
        boolean field = cofac.isField();
        GcdRingElem c = (GcdRingElem)cofac.getONE();
        do {
            if ((x = field ? q.remainder(r) : PolyUtil.baseSparsePseudoRemainder(q, r)).isZERO()) {
                return x;
            }
            e = q.degree(0);
            f = r.degree(0);
            if (e % 2L != 0L && f % 2L != 0L) {
                s = 1 - s;
            }
            g = x.degree(0);
            c2 = (GcdRingElem)r.leadingBaseCoefficient();
            i = 0;
            while ((long)i < e - g) {
                c = c.multiply(c2);
                ++i;
            }
            q = r;
            r = x;
        } while (g != 0L);
        c2 = (GcdRingElem)r.leadingBaseCoefficient();
        i = 0;
        while ((long)i < f) {
            c = c.multiply(c2);
            ++i;
        }
        if (s == 1) {
            c = (GcdRingElem)c.negate();
        }
        x = ((GenPolynomial)P.ring.getONE()).multiply(c);
        return x;
    }

    @Override
    public GenPolynomial<GenPolynomial<C>> recursiveUnivariateResultant(GenPolynomial<GenPolynomial<C>> P, GenPolynomial<GenPolynomial<C>> S) {
        int i;
        GenPolynomial<Object> c2;
        GenPolynomial<GenPolynomial<Object>> x;
        long g;
        GenPolynomial<GenPolynomial<Object>> q;
        GenPolynomial<GenPolynomial<Object>> r;
        if (S == null || S.isZERO()) {
            return S;
        }
        if (P == null || P.isZERO()) {
            return P;
        }
        if (P.ring.nvar > 1 || P.ring.nvar == 0) {
            throw new IllegalArgumentException("no recursive univariate polynomial");
        }
        long e = P.degree(0);
        long f = S.degree(0);
        if (f == 0L && e == 0L) {
            GenPolynomial<C> t = this.resultant(P.leadingBaseCoefficient(), S.leadingBaseCoefficient());
            return ((GenPolynomial)P.ring.getONE()).multiply(t);
        }
        if (e == 0L) {
            return Power.power(P.ring, P, f);
        }
        if (f == 0L) {
            return Power.power(S.ring, S, e);
        }
        int s = 0;
        if (f > e) {
            r = P;
            q = S;
            long g2 = f;
            f = e;
            e = g2;
            if (e % 2L != 0L && f % 2L != 0L) {
                s = 1;
            }
        } else {
            q = P;
            r = S;
        }
        RingFactory cofac = P.ring.coFac;
        AbelianGroupElem<GenPolynomial<Object>> c = (GenPolynomial<GenPolynomial<Object>>)cofac.getONE();
        do {
            if ((x = PolyUtil.recursiveSparsePseudoRemainder(q, r)).isZERO()) {
                return x;
            }
            e = q.degree(0);
            f = r.degree(0);
            if (e % 2L != 0L && f % 2L != 0L) {
                s = 1 - s;
            }
            g = x.degree(0);
            c2 = r.leadingBaseCoefficient();
            i = 0;
            while ((long)i < e - g) {
                c = c.multiply(c2);
                ++i;
            }
            q = r;
            r = x;
        } while (g != 0L);
        c2 = r.leadingBaseCoefficient();
        i = 0;
        while ((long)i < f) {
            c = c.multiply(c2);
            ++i;
        }
        if (s == 1) {
            c = c.negate();
        }
        x = ((GenPolynomial)P.ring.getONE()).multiply(c);
        return x;
    }
}

