/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd;

import cc.redberry.core.transformations.factor.jasfactor.edu.jas.arith.BigInteger;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.arith.BigRational;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.GenPolynomial;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.GenPolynomialRing;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.PolyUtil;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.FactorAbsolute;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.FactorAbstract;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.FactorFactory;
import java.util.ArrayList;
import java.util.List;

public class FactorRational
extends FactorAbsolute<BigRational> {
    protected final FactorAbstract<BigInteger> iengine = FactorFactory.getImplementation(BigInteger.ONE);

    protected FactorRational() {
        super(BigRational.ONE);
    }

    @Override
    public List<GenPolynomial<BigRational>> baseFactorsSquarefree(GenPolynomial<BigRational> P) {
        BigInteger bi;
        GenPolynomialRing<BigInteger> ifac;
        GenPolynomial<BigInteger> Pi;
        List<GenPolynomial<BigInteger>> ifacts;
        if (P == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P == null");
        }
        ArrayList<GenPolynomial<BigRational>> factors = new ArrayList<GenPolynomial<BigRational>>();
        if (P.isZERO()) {
            return factors;
        }
        if (P.isONE()) {
            factors.add(P);
            return factors;
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " only for univariate polynomials");
        }
        GenPolynomial<BigRational> Pr = P;
        BigRational ldcf = P.leadingBaseCoefficient();
        if (!ldcf.isONE()) {
            Pr = Pr.monic();
        }
        if ((ifacts = this.iengine.baseFactorsSquarefree(Pi = PolyUtil.integerFromRationalCoefficients(ifac = new GenPolynomialRing<BigInteger>(bi = BigInteger.ONE, pfac), Pr))).size() <= 1) {
            factors.add(P);
            return factors;
        }
        List rfacts = PolyUtil.fromIntegerCoefficients(pfac, ifacts);
        rfacts = PolyUtil.monic(rfacts);
        if (!ldcf.isONE()) {
            GenPolynomial<BigRational> r = rfacts.get(0);
            rfacts.remove(r);
            r = r.multiply(ldcf);
            rfacts.set(0, r);
        }
        factors.addAll(rfacts);
        return factors;
    }

    @Override
    public List<GenPolynomial<BigRational>> factorsSquarefree(GenPolynomial<BigRational> P) {
        BigInteger bi;
        GenPolynomialRing<BigInteger> ifac;
        GenPolynomial<BigInteger> Pi;
        List<GenPolynomial<BigInteger>> ifacts;
        if (P == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P == null");
        }
        ArrayList<GenPolynomial<BigRational>> factors = new ArrayList<GenPolynomial<BigRational>>();
        if (P.isZERO()) {
            return factors;
        }
        if (P.isONE()) {
            factors.add(P);
            return factors;
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar == 1) {
            return this.baseFactorsSquarefree(P);
        }
        GenPolynomial<BigRational> Pr = P;
        BigRational ldcf = P.leadingBaseCoefficient();
        if (!ldcf.isONE()) {
            Pr = Pr.monic();
        }
        if ((ifacts = this.iengine.factorsSquarefree(Pi = PolyUtil.integerFromRationalCoefficients(ifac = new GenPolynomialRing<BigInteger>(bi = BigInteger.ONE, pfac), Pr))).size() <= 1) {
            factors.add(P);
            return factors;
        }
        List rfacts = PolyUtil.fromIntegerCoefficients(pfac, ifacts);
        rfacts = PolyUtil.monic(rfacts);
        if (!ldcf.isONE()) {
            GenPolynomial<BigRational> r = rfacts.get(0);
            rfacts.remove(r);
            r = r.multiply(ldcf);
            rfacts.set(0, r);
        }
        factors.addAll(rfacts);
        return factors;
    }
}

