/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd;

import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.ExpVector;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.GenPolynomial;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.GenPolynomialRing;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.PolyUtil;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.AbelianGroupElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.GcdRingElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.RingFactory;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.Factorization;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.GCDFactory;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.GreatestCommonDivisorAbstract;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.PolyUfdUtil;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.SquarefreeAbstract;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.SquarefreeFactory;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.util.KsubSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public abstract class FactorAbstract<C extends GcdRingElem<C>>
implements Factorization<C> {
    protected final GreatestCommonDivisorAbstract<C> engine;
    protected final SquarefreeAbstract<C> sengine;

    protected FactorAbstract() {
        throw new IllegalArgumentException("don't use this constructor");
    }

    public FactorAbstract(RingFactory<C> cfac) {
        this.engine = GCDFactory.getProxy(cfac);
        this.sengine = SquarefreeFactory.getImplementation(cfac);
    }

    public String toString() {
        return this.getClass().getName();
    }

    @Override
    public boolean isIrreducible(GenPolynomial<C> P) {
        if (!this.isSquarefree(P)) {
            return false;
        }
        List<GenPolynomial<C>> F = this.factorsSquarefree(P);
        if (F.size() == 1) {
            return true;
        }
        if (F.size() > 2) {
            return false;
        }
        boolean cnst = false;
        for (GenPolynomial<C> p : F) {
            if (!p.isConstant()) continue;
            cnst = true;
        }
        return cnst;
    }

    public boolean isSquarefree(GenPolynomial<C> P) {
        return this.sengine.isSquarefree(P);
    }

    public List<GenPolynomial<C>> factorsSquarefree(GenPolynomial<C> P) {
        if (P == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P != null");
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar == 1) {
            return this.baseFactorsSquarefree(P);
        }
        ArrayList<GenPolynomial<C>> factors = new ArrayList<GenPolynomial<C>>();
        if (P.isZERO()) {
            return factors;
        }
        if (P.degreeVector().totalDeg() <= 1L) {
            factors.add(P);
            return factors;
        }
        long d = P.degree() + 1L;
        GenPolynomial<C> kr = PolyUfdUtil.substituteKronecker(P, d);
        GenPolynomialRing ufac = kr.ring;
        ufac.setVars(ufac.newVars("zz"));
        List ulist = new ArrayList<GenPolynomial<C>>();
        SortedMap<GenPolynomial<C>, Long> slist = this.baseFactors(kr);
        for (Map.Entry<GenPolynomial<C>, Long> me : slist.entrySet()) {
            GenPolynomial<C> g = me.getKey();
            long e = me.getValue();
            int i = 0;
            while ((long)i < e) {
                ulist.add(g);
                ++i;
            }
        }
        if (ulist.size() == 1 && ((GenPolynomial)ulist.get(0)).degree() == P.degree()) {
            factors.add(P);
            return factors;
        }
        int dl = ulist.size() - 1;
        int ti = 0;
        GenPolynomial<C> u = P;
        long deg = (u.degree() + 1L) / 2L;
        ExpVector evl = u.leadingExpVector();
        ExpVector evt = u.trailingExpVector();
        block2: for (int j = 1; j <= dl; ++j) {
            KsubSet ps = new KsubSet(ulist, j);
            for (List flist : ps) {
                GenPolynomial<C> rem;
                GenPolynomial<GenPolynomial> utrial = ufac.getONE();
                for (GenPolynomial aFlist : flist) {
                    utrial = utrial.multiply(aFlist);
                }
                GenPolynomial trial = PolyUfdUtil.backSubstituteKronecker(pfac, utrial, d);
                ++ti;
                if (!evl.multipleOf(trial.leadingExpVector()) || !evt.multipleOf(trial.trailingExpVector()) || trial.degree() > deg || trial.isConstant()) continue;
                trial = trial.monic();
                if (ti % 15000 == 0) {
                    // empty if block
                }
                if (!(rem = PolyUtil.baseSparsePseudoRemainder(u, trial)).isZERO()) continue;
                factors.add(trial);
                u = PolyUtil.basePseudoDivide(u, trial);
                evl = u.leadingExpVector();
                evt = u.trailingExpVector();
                if (u.isConstant()) {
                    j = dl + 1;
                    continue block2;
                }
                ulist = FactorAbstract.removeOnce(ulist, flist);
                dl = (ulist.size() + 1) / 2;
                j = 0;
                continue block2;
            }
        }
        if (!u.isONE() && !u.equals(P)) {
            factors.add(u);
        }
        if (factors.size() == 0) {
            factors.add(P);
        }
        return this.normalizeFactorization(factors);
    }

    static <T> List<T> removeOnce(List<T> a, List<T> b) {
        ArrayList<T> res = new ArrayList<T>();
        res.addAll(a);
        for (T e : b) {
            res.remove(e);
        }
        return res;
    }

    public List<GenPolynomial<C>> baseFactorsRadical(GenPolynomial<C> P) {
        return new ArrayList<GenPolynomial<C>>(this.baseFactors(P).keySet());
    }

    public boolean isFactorization(GenPolynomial<C> P, SortedMap<GenPolynomial<C>, Long> F) {
        return this.sengine.isFactorization(P, F);
    }

    public SortedMap<GenPolynomial<C>, Long> baseFactors(GenPolynomial<C> P) {
        SortedMap<GenPolynomial<C>, Long> facs;
        GcdRingElem c;
        if (P == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P != null");
        }
        GenPolynomialRing pfac = P.ring;
        TreeMap<GenPolynomial<C>, Long> factors = new TreeMap<GenPolynomial<C>, Long>(pfac.getComparator());
        if (P.isZERO()) {
            return factors;
        }
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " only for univariate polynomials");
        }
        if (P.isConstant()) {
            factors.put(P, 1L);
            return factors;
        }
        if (pfac.coFac.isField()) {
            c = (GcdRingElem)P.leadingBaseCoefficient();
        } else {
            c = this.engine.baseContent(P);
            if (P.signum() < 0 && c.signum() > 0) {
                c = (GcdRingElem)c.negate();
            }
        }
        if (!c.isONE()) {
            GenPolynomial pc = ((GenPolynomial)pfac.getONE()).multiply(c);
            factors.put(pc, 1L);
            P = P.divide(c);
        }
        if ((facs = this.sengine.baseSquarefreeFactors(P)) == null || facs.size() == 0) {
            facs = new TreeMap<GenPolynomial<C>, Long>();
            facs.put(P, 1L);
        }
        for (Map.Entry<GenPolynomial<C>, Long> me : facs.entrySet()) {
            GenPolynomial<C> g = me.getKey();
            Long k = me.getValue();
            if (pfac.coFac.isField() && !((GcdRingElem)g.leadingBaseCoefficient()).isONE()) {
                g = g.monic();
            }
            if (g.degree(0) <= 1L) {
                if (g.isONE()) continue;
                factors.put(g, k);
                continue;
            }
            List<GenPolynomial<C>> sfacs = this.baseFactorsSquarefree(g);
            for (GenPolynomial<C> h : sfacs) {
                Long j = (Long)factors.get(h);
                if (j != null) {
                    k = k + j;
                }
                if (h.isONE()) continue;
                factors.put(h, k);
            }
        }
        return factors;
    }

    public abstract List<GenPolynomial<C>> baseFactorsSquarefree(GenPolynomial<C> var1);

    public SortedMap<GenPolynomial<C>, Long> factors(GenPolynomial<C> P) {
        SortedMap<GenPolynomial<C>, Long> facs;
        GcdRingElem c;
        if (P == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P != null");
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar == 1) {
            return this.baseFactors(P);
        }
        TreeMap<GenPolynomial<C>, Long> factors = new TreeMap<GenPolynomial<C>, Long>(pfac.getComparator());
        if (P.isZERO()) {
            return factors;
        }
        if (P.isConstant()) {
            factors.put(P, 1L);
            return factors;
        }
        if (pfac.coFac.isField()) {
            c = (GcdRingElem)P.leadingBaseCoefficient();
        } else {
            c = this.engine.baseContent(P);
            if (P.signum() < 0 && c.signum() > 0) {
                c = (GcdRingElem)c.negate();
            }
        }
        if (!c.isONE()) {
            GenPolynomial pc = ((GenPolynomial)pfac.getONE()).multiply(c);
            factors.put(pc, 1L);
            P = P.divide(c);
        }
        if ((facs = this.sengine.squarefreeFactors(P)) == null || facs.size() == 0) {
            facs = new TreeMap<GenPolynomial<C>, Long>();
            facs.put(P, 1L);
            throw new RuntimeException("this should not happen, facs is empty: " + facs);
        }
        for (Map.Entry<GenPolynomial<C>, Long> me : facs.entrySet()) {
            GenPolynomial<C> g = me.getKey();
            if (g.isONE()) continue;
            Long d = me.getValue();
            List<GenPolynomial<C>> sfacs = this.factorsSquarefree(g);
            for (GenPolynomial<C> h : sfacs) {
                long dd = d;
                Long j = (Long)factors.get(h);
                if (j != null) {
                    dd += j.longValue();
                }
                factors.put(h, dd);
            }
        }
        return factors;
    }

    public List<GenPolynomial<GenPolynomial<C>>> recursiveFactorsSquarefree(GenPolynomial<GenPolynomial<C>> P) {
        List ifacts;
        GenPolynomialRing pfac;
        if (P == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P == null");
        }
        ArrayList<GenPolynomial<GenPolynomial<C>>> factors = new ArrayList<GenPolynomial<GenPolynomial<C>>>();
        if (P.isZERO()) {
            return factors;
        }
        if (P.isONE()) {
            factors.add(P);
            return factors;
        }
        GenPolynomialRing qi = (GenPolynomialRing)pfac.coFac;
        pfac = P.ring;
        GenPolynomialRing ifac = qi.extend(pfac.getVars());
        GenPolynomial Pi = PolyUtil.distribute(ifac, P);
        GcdRingElem ldcf = (GcdRingElem)Pi.leadingBaseCoefficient();
        if (!ldcf.isONE() && ldcf.isUnit()) {
            Pi = Pi.monic();
        }
        if ((ifacts = this.factorsSquarefree(Pi)).size() <= 1) {
            factors.add(P);
            return factors;
        }
        if (!ldcf.isONE() && ldcf.isUnit()) {
            GenPolynomial<GcdRingElem> r = ifacts.get(0);
            ifacts.remove(r);
            r = r.multiply(ldcf);
            ifacts.add(0, r);
        }
        List rfacts = PolyUtil.recursive(pfac, ifacts);
        factors.addAll(rfacts);
        return factors;
    }

    public List<GenPolynomial<C>> normalizeFactorization(List<GenPolynomial<C>> F) {
        if (F == null || F.size() <= 1) {
            return F;
        }
        ArrayList<GenPolynomial<C>> Fp = new ArrayList<GenPolynomial<C>>(F.size());
        AbelianGroupElem<GenPolynomial<C>> f0 = F.get(0);
        for (int i = 1; i < F.size(); ++i) {
            AbelianGroupElem<GenPolynomial<C>> fi = F.get(i);
            if (fi.signum() < 0) {
                fi = fi.negate();
                f0 = f0.negate();
            }
            Fp.add((GenPolynomial<C>)fi);
        }
        if (!f0.isONE()) {
            Fp.add(0, (GenPolynomial<C>)f0);
        }
        return Fp;
    }
}

