/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure;

import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.AbelianGroupElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.AbelianGroupFactory;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.MonoidElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.MonoidFactory;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.RingElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.RingFactory;
import java.math.BigInteger;
import java.util.List;

public class Power<C extends RingElem<C>> {
    private final RingFactory<C> fac;

    public Power() {
        this(null);
    }

    public Power(RingFactory<C> fac) {
        this.fac = fac;
    }

    public static <C extends RingElem<C>> C positivePower(C a, long n) {
        if (n <= 0L) {
            throw new IllegalArgumentException("only positive n allowed");
        }
        if (a.isZERO() || a.isONE()) {
            return a;
        }
        C b = a;
        long i = n - 1L;
        C p = b;
        do {
            if (i % 2L == 1L) {
                p = p.multiply(b);
            }
            if ((i /= 2L) <= 0L) continue;
            b = b.multiply(b);
        } while (i > 0L);
        return p;
    }

    public static <C extends RingElem<C>> C positivePower(C a, BigInteger n) {
        if (n.signum() <= 0) {
            throw new IllegalArgumentException("only positive n allowed");
        }
        if (a.isZERO() || a.isONE()) {
            return a;
        }
        C b = a;
        if (n.compareTo(BigInteger.ONE) == 0) {
            return b;
        }
        C p = a;
        BigInteger i = n.subtract(BigInteger.ONE);
        do {
            if (i.testBit(0)) {
                p = p.multiply(b);
            }
            if ((i = i.shiftRight(1)).signum() <= 0) continue;
            b = b.multiply(b);
        } while (i.signum() > 0);
        return p;
    }

    public static <C extends RingElem<C>> C power(RingFactory<C> fac, C a, long n) {
        if (a == null || a.isZERO()) {
            return a;
        }
        return (C)((RingElem)Power.power(fac, a, n));
    }

    public static <C extends MonoidElem<C>> C power(MonoidFactory<C> fac, C a, long n) {
        if (n == 0L) {
            if (fac == null) {
                throw new IllegalArgumentException("fac may not be null for a^0");
            }
            return fac.getONE();
        }
        if (a.isONE()) {
            return a;
        }
        C b = a;
        if (n < 0L) {
            b = a.inverse();
            n = -n;
        }
        if (n == 1L) {
            return b;
        }
        C p = fac.getONE();
        long i = n;
        do {
            if (i % 2L == 1L) {
                p = p.multiply(b);
            }
            if ((i /= 2L) <= 0L) continue;
            b = b.multiply(b);
        } while (i > 0L);
        return p;
    }

    public static <C extends MonoidElem<C>> C modPower(MonoidFactory<C> fac, C a, BigInteger n, C m) {
        if (n.signum() == 0) {
            if (fac == null) {
                throw new IllegalArgumentException("fac may not be null for a^0");
            }
            return fac.getONE();
        }
        if (a.isONE()) {
            return a;
        }
        C b = a.remainder(m);
        if (n.signum() < 0) {
            b = a.inverse().remainder(m);
            n = n.negate();
        }
        if (n.compareTo(BigInteger.ONE) == 0) {
            return b;
        }
        C p = fac.getONE();
        BigInteger i = n;
        do {
            if (i.testBit(0)) {
                p = p.multiply(b).remainder(m);
            }
            if ((i = i.shiftRight(1)).signum() <= 0) continue;
            b = b.multiply(b).remainder(m);
        } while (i.signum() > 0);
        return p;
    }

    public C power(C a, long n) {
        return Power.power(this.fac, a, n);
    }

    public C modPower(C a, BigInteger n, C m) {
        return (C)((RingElem)Power.modPower(this.fac, a, n, m));
    }

    public static <C extends RingElem<C>> long logarithm(C p, C a) {
        long k = 1L;
        C m = p;
        while (m.compareTo(a) < 0) {
            m = m.multiply(p);
            ++k;
        }
        return k;
    }

    public static <C extends RingElem<C>> C multiply(RingFactory<C> fac, List<C> A) {
        return (C)((RingElem)Power.multiply(fac, A));
    }

    public static <C extends MonoidElem<C>> C multiply(MonoidFactory<C> fac, List<C> A) {
        if (fac == null) {
            throw new IllegalArgumentException("fac may not be null for empty list");
        }
        MonoidElem res = fac.getONE();
        if (A == null || A.isEmpty()) {
            return (C)res;
        }
        for (MonoidElem a : A) {
            res = res.multiply((MonoidElem)a);
        }
        return (C)res;
    }

    public static <C extends RingElem<C>> C sum(RingFactory<C> fac, List<C> A) {
        return (C)((RingElem)Power.sum(fac, A));
    }

    public static <C extends AbelianGroupElem<C>> C sum(AbelianGroupFactory<C> fac, List<C> A) {
        if (fac == null) {
            throw new IllegalArgumentException("fac may not be null for empty list");
        }
        AbelianGroupElem res = fac.getZERO();
        if (A == null || A.isEmpty()) {
            return (C)res;
        }
        for (AbelianGroupElem a : A) {
            res = res.sum((AbelianGroupElem)a);
        }
        return (C)res;
    }
}

