/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly;

import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.ExpVector;

public final class ExpVectorByte
extends ExpVector {
    final byte[] val;
    public static final long maxByte = 63L;
    public static final long minByte = -64L;

    public ExpVectorByte(int n) {
        this(new byte[n]);
    }

    public ExpVectorByte(int n, int i, long e) {
        this(n);
        if (e >= 63L || e <= -64L) {
            throw new IllegalArgumentException("exponent to large: " + e);
        }
        this.val[i] = (byte)e;
    }

    protected ExpVectorByte(byte[] v) {
        this.val = v;
    }

    public ExpVectorByte(long[] v) {
        this(v.length);
        for (int i = 0; i < v.length; ++i) {
            if (v[i] >= 63L || v[i] <= -64L) {
                throw new IllegalArgumentException("exponent to large: " + v[i]);
            }
            this.val[i] = (byte)v[i];
        }
    }

    @Override
    public ExpVectorByte copy() {
        byte[] w = new byte[this.val.length];
        System.arraycopy(this.val, 0, w, 0, this.val.length);
        return new ExpVectorByte(w);
    }

    @Override
    long[] getVal() {
        long[] v = new long[this.val.length];
        for (int i = 0; i < this.val.length; ++i) {
            v[i] = this.val[i];
        }
        return v;
    }

    @Override
    public long getVal(int i) {
        return this.val[i];
    }

    @Override
    protected long setVal(int i, long e) {
        byte x = this.val[i];
        if (e >= 63L || e <= -64L) {
            throw new IllegalArgumentException("exponent to large: " + e);
        }
        this.val[i] = (byte)e;
        this.hash = 0;
        return x;
    }

    @Override
    public int length() {
        return this.val.length;
    }

    @Override
    public ExpVectorByte extend(int i, int j, long e) {
        byte[] w = new byte[this.val.length + i];
        System.arraycopy(this.val, 0, w, i, this.val.length);
        if (j >= i) {
            throw new IllegalArgumentException("i " + i + " <= j " + j + " invalid");
        }
        if (e >= 63L || e <= -64L) {
            throw new IllegalArgumentException("exponent to large: " + e);
        }
        w[j] = (byte)e;
        return new ExpVectorByte(w);
    }

    @Override
    public ExpVectorByte extendLower(int i, int j, long e) {
        byte[] w = new byte[this.val.length + i];
        System.arraycopy(this.val, 0, w, 0, this.val.length);
        if (j >= i) {
            throw new IllegalArgumentException("i " + i + " <= j " + j + " invalid");
        }
        w[this.val.length + j] = (byte)e;
        return new ExpVectorByte(w);
    }

    @Override
    public ExpVectorByte contract(int i, int len) {
        if (i + len > this.val.length) {
            throw new IllegalArgumentException("len " + len + " > val.len " + this.val.length);
        }
        byte[] w = new byte[len];
        System.arraycopy(this.val, i, w, 0, len);
        return new ExpVectorByte(w);
    }

    @Override
    public ExpVectorByte reverse() {
        byte[] w = new byte[this.val.length];
        for (int i = 0; i < this.val.length; ++i) {
            w[i] = this.val[this.val.length - 1 - i];
        }
        return new ExpVectorByte(w);
    }

    @Override
    public ExpVectorByte reverse(int j) {
        if (j <= 0 || j > this.val.length) {
            return this;
        }
        byte[] w = new byte[this.val.length];
        for (int i = 0; i < j; ++i) {
            w[i] = this.val[j - 1 - i];
        }
        System.arraycopy(this.val, j, w, j, this.val.length - j);
        return new ExpVectorByte(w);
    }

    @Override
    public ExpVectorByte combine(ExpVector V) {
        if (V == null || V.length() == 0) {
            return this;
        }
        ExpVectorByte Vi = (ExpVectorByte)V;
        if (this.val.length == 0) {
            return Vi;
        }
        byte[] w = new byte[this.val.length + Vi.val.length];
        System.arraycopy(this.val, 0, w, 0, this.val.length);
        System.arraycopy(Vi.val, 0, w, this.val.length, Vi.val.length);
        return new ExpVectorByte(w);
    }

    @Override
    public String toString() {
        return super.toString() + ":byte";
    }

    @Override
    public boolean equals(Object B) {
        if (!(B instanceof ExpVectorByte)) {
            return false;
        }
        ExpVectorByte b = (ExpVectorByte)B;
        int t = this.invLexCompareTo(b);
        return 0 == t;
    }

    @Override
    public ExpVectorByte abs() {
        byte[] u = this.val;
        byte[] w = new byte[u.length];
        for (int i = 0; i < u.length; ++i) {
            w[i] = (long)u[i] >= 0L ? u[i] : (byte)(-u[i]);
        }
        return new ExpVectorByte(w);
    }

    @Override
    public ExpVectorByte negate() {
        byte[] u = this.val;
        byte[] w = new byte[u.length];
        for (int i = 0; i < u.length; ++i) {
            w[i] = -u[i];
        }
        return new ExpVectorByte(w);
    }

    @Override
    public ExpVectorByte sum(ExpVector V) {
        byte[] u = this.val;
        byte[] v = ((ExpVectorByte)V).val;
        byte[] w = new byte[u.length];
        for (int i = 0; i < u.length; ++i) {
            w[i] = (byte)(u[i] + v[i]);
        }
        return new ExpVectorByte(w);
    }

    @Override
    public ExpVectorByte subtract(ExpVector V) {
        byte[] u = this.val;
        byte[] v = ((ExpVectorByte)V).val;
        byte[] w = new byte[u.length];
        for (int i = 0; i < u.length; ++i) {
            w[i] = (byte)(u[i] - v[i]);
        }
        return new ExpVectorByte(w);
    }

    @Override
    public ExpVectorByte subst(int i, long d) {
        ExpVectorByte V = this.copy();
        return V;
    }

    @Override
    public int signum() {
        byte[] u;
        int t = 0;
        for (byte anU : u = this.val) {
            if (anU < 0) {
                return -1;
            }
            if (anU <= 0) continue;
            t = 1;
        }
        return t;
    }

    @Override
    public long totalDeg() {
        byte[] u;
        long t = 0L;
        for (byte anU : u = this.val) {
            t += (long)anU;
        }
        return t;
    }

    @Override
    public long maxDeg() {
        byte[] u;
        long t = 0L;
        for (byte anU : u = this.val) {
            if ((long)anU <= t) continue;
            t = anU;
        }
        return t;
    }

    @Override
    public ExpVectorByte lcm(ExpVector V) {
        byte[] u = this.val;
        byte[] v = ((ExpVectorByte)V).val;
        byte[] w = new byte[u.length];
        for (int i = 0; i < u.length; ++i) {
            w[i] = u[i] >= v[i] ? u[i] : v[i];
        }
        return new ExpVectorByte(w);
    }

    @Override
    public ExpVectorByte gcd(ExpVector V) {
        byte[] u = this.val;
        byte[] v = ((ExpVectorByte)V).val;
        byte[] w = new byte[u.length];
        for (int i = 0; i < u.length; ++i) {
            w[i] = u[i] <= v[i] ? u[i] : v[i];
        }
        return new ExpVectorByte(w);
    }

    @Override
    public int[] dependencyOnVariables() {
        byte[] u = this.val;
        int l = 0;
        for (byte anU : u) {
            if (anU <= 0) continue;
            ++l;
        }
        int[] dep = new int[l];
        if (l == 0) {
            return dep;
        }
        int j = 0;
        for (int i = 0; i < u.length; ++i) {
            if (u[i] <= 0) continue;
            dep[j] = i;
            ++j;
        }
        return dep;
    }

    @Override
    public boolean multipleOf(ExpVector V) {
        byte[] u = this.val;
        byte[] v = ((ExpVectorByte)V).val;
        boolean t = true;
        for (int i = 0; i < u.length; ++i) {
            if (u[i] >= v[i]) continue;
            return false;
        }
        return t;
    }

    @Override
    public int compareTo(ExpVector V) {
        return this.invLexCompareTo(V);
    }

    @Override
    public int invLexCompareTo(ExpVector V) {
        byte[] u = this.val;
        byte[] v = ((ExpVectorByte)V).val;
        int t = 0;
        for (int i = 0; i < u.length; ++i) {
            if (u[i] > v[i]) {
                return 1;
            }
            if (u[i] >= v[i]) continue;
            return -1;
        }
        return t;
    }

    @Override
    public int invLexCompareTo(ExpVector V, int begin, int end) {
        byte[] u = this.val;
        byte[] v = ((ExpVectorByte)V).val;
        int t = 0;
        for (int i = begin; i < end; ++i) {
            if (u[i] > v[i]) {
                return 1;
            }
            if (u[i] >= v[i]) continue;
            return -1;
        }
        return t;
    }

    @Override
    public int invGradCompareTo(ExpVector V) {
        byte[] u = this.val;
        byte[] v = ((ExpVectorByte)V).val;
        int t = 0;
        for (int i = 0; i < u.length; ++i) {
            if (u[i] > v[i]) {
                t = 1;
                break;
            }
            if (u[i] >= v[i]) continue;
            t = -1;
            break;
        }
        if (t == 0) {
            return t;
        }
        long up = 0L;
        long vp = 0L;
        for (int j = i; j < u.length; ++j) {
            up += (long)u[j];
            vp += (long)v[j];
        }
        if (up > vp) {
            t = 1;
        } else if (up < vp) {
            t = -1;
        }
        return t;
    }

    @Override
    public int invGradCompareTo(ExpVector V, int begin, int end) {
        byte[] u = this.val;
        byte[] v = ((ExpVectorByte)V).val;
        int t = 0;
        for (int i = begin; i < end; ++i) {
            if (u[i] > v[i]) {
                t = 1;
                break;
            }
            if (u[i] >= v[i]) continue;
            t = -1;
            break;
        }
        if (t == 0) {
            return t;
        }
        long up = 0L;
        long vp = 0L;
        for (int j = i; j < end; ++j) {
            up += (long)u[j];
            vp += (long)v[j];
        }
        if (up > vp) {
            t = 1;
        } else if (up < vp) {
            t = -1;
        }
        return t;
    }

    @Override
    public int revInvLexCompareTo(ExpVector V) {
        byte[] u = this.val;
        byte[] v = ((ExpVectorByte)V).val;
        int t = 0;
        for (int i = u.length - 1; i >= 0; --i) {
            if (u[i] > v[i]) {
                return 1;
            }
            if (u[i] >= v[i]) continue;
            return -1;
        }
        return t;
    }

    @Override
    public int revInvLexCompareTo(ExpVector V, int begin, int end) {
        byte[] u = this.val;
        byte[] v = ((ExpVectorByte)V).val;
        int t = 0;
        for (int i = end - 1; i >= begin; --i) {
            if (u[i] > v[i]) {
                return 1;
            }
            if (u[i] >= v[i]) continue;
            return -1;
        }
        return t;
    }

    @Override
    public int revInvGradCompareTo(ExpVector V) {
        byte[] u = this.val;
        byte[] v = ((ExpVectorByte)V).val;
        int t = 0;
        for (int i = u.length - 1; i >= 0; --i) {
            if (u[i] > v[i]) {
                t = 1;
                break;
            }
            if (u[i] >= v[i]) continue;
            t = -1;
            break;
        }
        if (t == 0) {
            return t;
        }
        long up = 0L;
        long vp = 0L;
        for (int j = i; j >= 0; --j) {
            up += (long)u[j];
            vp += (long)v[j];
        }
        if (up > vp) {
            t = 1;
        } else if (up < vp) {
            t = -1;
        }
        return t;
    }

    @Override
    public int revInvGradCompareTo(ExpVector V, int begin, int end) {
        byte[] u = this.val;
        byte[] v = ((ExpVectorByte)V).val;
        int t = 0;
        for (int i = end - 1; i >= begin; --i) {
            if (u[i] > v[i]) {
                t = 1;
                break;
            }
            if (u[i] >= v[i]) continue;
            t = -1;
            break;
        }
        if (t == 0) {
            return t;
        }
        long up = 0L;
        long vp = 0L;
        for (int j = i; j >= begin; --j) {
            up += (long)u[j];
            vp += (long)v[j];
        }
        if (up > vp) {
            t = 1;
        } else if (up < vp) {
            t = -1;
        }
        return t;
    }

    @Override
    public int invWeightCompareTo(long[][] w, ExpVector V) {
        byte[] u = this.val;
        byte[] v = ((ExpVectorByte)V).val;
        int t = 0;
        for (int i = 0; i < u.length; ++i) {
            if (u[i] > v[i]) {
                t = 1;
                break;
            }
            if (u[i] >= v[i]) continue;
            t = -1;
            break;
        }
        if (t == 0) {
            return t;
        }
        for (long[] wk : w) {
            long up = 0L;
            long vp = 0L;
            for (int j = i; j < u.length; ++j) {
                up += wk[j] * (long)u[j];
                vp += wk[j] * (long)v[j];
            }
            if (up > vp) {
                return 1;
            }
            if (up >= vp) continue;
            return -1;
        }
        return t;
    }
}

