/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly;

import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.AlgebraicNumberRing;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.Complex;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.GenPolynomial;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.GenPolynomialRing;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.TermOrder;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.MonoidElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.RingElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.RingFactory;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class ComplexRing<C extends RingElem<C>>
implements RingFactory<Complex<C>> {
    private static final Random random = new Random();
    public final RingFactory<C> ring;

    public ComplexRing(RingFactory<C> ring) {
        this.ring = ring;
    }

    @Override
    public List<Complex<C>> generators() {
        List gens = this.ring.generators();
        ArrayList<Complex<C>> g = new ArrayList<Complex<C>>(gens.size() + 1);
        for (RingElem x : gens) {
            Complex<RingElem> cx = new Complex<RingElem>(this, x);
            g.add(cx);
        }
        g.add(this.getIMAG());
        return g;
    }

    public AlgebraicNumberRing<C> algebraicRing() {
        GenPolynomialRing<C> pfac = new GenPolynomialRing<C>(this.ring, 1, new TermOrder(2), new String[]{"I"});
        GenPolynomial<MonoidElem> I = pfac.univariate(0, 2L).sum(pfac.getONE());
        AlgebraicNumberRing<MonoidElem> afac = new AlgebraicNumberRing<MonoidElem>(I, this.ring.isField());
        return afac;
    }

    @Override
    public boolean isFinite() {
        return this.ring.isFinite();
    }

    @Override
    public Complex<C> copy(Complex<C> c) {
        return new Complex(this, c.re, c.im);
    }

    @Override
    public Complex<C> getZERO() {
        return new Complex(this);
    }

    @Override
    public Complex<C> getONE() {
        return new Complex<RingElem>(this, (RingElem)this.ring.getONE());
    }

    public Complex<C> getIMAG() {
        return new Complex<RingElem>(this, (RingElem)this.ring.getZERO(), (RingElem)this.ring.getONE());
    }

    @Override
    public boolean isCommutative() {
        return this.ring.isCommutative();
    }

    @Override
    public boolean isAssociative() {
        return this.ring.isAssociative();
    }

    @Override
    public boolean isField() {
        return this.ring.isField();
    }

    @Override
    public BigInteger characteristic() {
        return this.ring.characteristic();
    }

    @Override
    public Complex<C> fromInteger(BigInteger a) {
        return new Complex<RingElem>(this, (RingElem)this.ring.fromInteger(a));
    }

    @Override
    public Complex<C> fromInteger(long a) {
        return new Complex<RingElem>(this, (RingElem)this.ring.fromInteger(a));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Complex[");
        sb.append(this.ring.toString());
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object b) {
        if (!(b instanceof ComplexRing)) {
            return false;
        }
        ComplexRing a = null;
        try {
            a = (ComplexRing)b;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (a == null) {
            return false;
        }
        return this.ring.equals(a.ring);
    }

    public int hashCode() {
        return this.ring.hashCode();
    }

    @Override
    public Complex<C> random(int n) {
        return this.random(n, random);
    }

    @Override
    public Complex<C> random(int n, Random rnd) {
        RingElem r = (RingElem)this.ring.random(n, rnd);
        RingElem i = (RingElem)this.ring.random(n, rnd);
        return new Complex<RingElem>(this, r, i);
    }
}

