/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly;

import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.ComplexRing;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.AbelianGroupElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.Element;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.GcdRingElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.MonoidElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.RingElem;

public class Complex<C extends RingElem<C>>
implements GcdRingElem<Complex<C>> {
    private static final boolean debug = false;
    public final ComplexRing<C> ring;
    protected final C re;
    protected final C im;

    public Complex(ComplexRing<C> ring, C r, C i) {
        this.ring = ring;
        this.re = r;
        this.im = i;
    }

    public Complex(ComplexRing<C> ring, C r) {
        this((ComplexRing<RingElem>)ring, (RingElem)r, (RingElem)ring.ring.getZERO());
    }

    public Complex(ComplexRing<C> ring, long r) {
        this(ring, (RingElem)ring.ring.fromInteger(r));
    }

    public Complex(ComplexRing<C> ring) {
        this(ring, (RingElem)ring.ring.getZERO());
    }

    @Override
    public ComplexRing<C> factory() {
        return this.ring;
    }

    public C getRe() {
        return this.re;
    }

    public C getIm() {
        return this.im;
    }

    @Override
    public Complex<C> copy() {
        return new Complex<C>(this.ring, this.re, this.im);
    }

    public String toString() {
        String s = this.re.toString();
        if (this.im.isZERO()) {
            return s;
        }
        s = s + "i" + this.im;
        return s;
    }

    @Override
    public boolean isZERO() {
        return this.re.isZERO() && this.im.isZERO();
    }

    @Override
    public boolean isONE() {
        return this.re.isONE() && this.im.isZERO();
    }

    public boolean isIMAG() {
        return this.re.isZERO() && this.im.isONE();
    }

    @Override
    public boolean isUnit() {
        if (this.isZERO()) {
            return false;
        }
        if (this.ring.isField()) {
            return true;
        }
        return this.norm().re.isUnit();
    }

    @Override
    public boolean equals(Object b) {
        if (!(b instanceof Complex)) {
            return false;
        }
        Complex bc = null;
        try {
            bc = (Complex)b;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (bc == null) {
            return false;
        }
        if (!this.ring.equals(bc.ring)) {
            return false;
        }
        return this.re.equals(bc.re) && this.im.equals(bc.im);
    }

    @Override
    public int hashCode() {
        return 37 * this.re.hashCode() + this.im.hashCode();
    }

    @Override
    public int compareTo(Complex<C> b) {
        int s = this.re.compareTo(b.re);
        if (s != 0) {
            return s;
        }
        return this.im.compareTo(b.im);
    }

    @Override
    public int signum() {
        int s = this.re.signum();
        if (s != 0) {
            return s;
        }
        return this.im.signum();
    }

    @Override
    public Complex<C> sum(Complex<C> B) {
        return new Complex<RingElem>(this.ring, (RingElem)this.re.sum(B.re), (RingElem)this.im.sum(B.im));
    }

    @Override
    public Complex<C> subtract(Complex<C> B) {
        return new Complex<RingElem>(this.ring, (RingElem)this.re.subtract(B.re), (RingElem)this.im.subtract(B.im));
    }

    @Override
    public Complex<C> negate() {
        return new Complex<RingElem>(this.ring, (RingElem)this.re.negate(), (RingElem)this.im.negate());
    }

    public Complex<C> conjugate() {
        return new Complex<RingElem>((ComplexRing<RingElem>)this.ring, (RingElem)this.re, (RingElem)this.im.negate());
    }

    public Complex<C> norm() {
        RingElem v = (RingElem)this.re.multiply(this.re);
        v = (RingElem)v.sum((AbelianGroupElem)this.im.multiply(this.im));
        return new Complex<RingElem>(this.ring, v);
    }

    @Override
    public Complex<C> abs() {
        Complex<C> n = this.norm();
        return n;
    }

    @Override
    public Complex<C> multiply(Complex<C> B) {
        return new Complex<RingElem>(this.ring, (RingElem)((RingElem)this.re.multiply(B.re)).subtract((AbelianGroupElem)this.im.multiply(B.im)), (RingElem)((RingElem)this.re.multiply(B.im)).sum((AbelianGroupElem)this.im.multiply(B.re)));
    }

    @Override
    public Complex<C> inverse() {
        RingElem a = (RingElem)this.norm().re.inverse();
        return new Complex<RingElem>(this.ring, this.re.multiply((RingElem)a), (RingElem)this.im.multiply((MonoidElem)((MonoidElem)a.negate())));
    }

    @Override
    public Complex<C> remainder(Complex<C> S) {
        if (this.ring.isField()) {
            return this.ring.getZERO();
        }
        return this.quotientRemainder(S)[1];
    }

    @Override
    public Complex<C> divide(Complex<C> B) {
        if (this.ring.isField()) {
            return this.multiply((Complex<C>)B.inverse());
        }
        return this.quotientRemainder(B)[0];
    }

    public Complex<C>[] quotientRemainder(Complex<C> S) {
        Complex[] ret = new Complex[2];
        C n = S.norm().re;
        Complex<Object> Sp = this.multiply(S.conjugate());
        RingElem qr = (RingElem)Sp.re.divide(n);
        RingElem rr = (RingElem)Sp.re.remainder(n);
        RingElem qi = (RingElem)Sp.im.divide(n);
        RingElem ri = (RingElem)Sp.im.remainder(n);
        RingElem rr1 = rr;
        RingElem ri1 = ri;
        if (rr.signum() < 0) {
            rr = (RingElem)rr.negate();
        }
        if (ri.signum() < 0) {
            ri = (RingElem)ri.negate();
        }
        RingElem one = (RingElem)n.factory().fromInteger(1L);
        if (rr.sum(rr).compareTo(n) > 0) {
            qr = rr1.signum() < 0 ? qr.subtract(one) : qr.sum(one);
        }
        if (ri.sum(ri).compareTo(n) > 0) {
            qi = ri1.signum() < 0 ? qi.subtract(one) : qi.sum(one);
        }
        Sp = new Complex<RingElem>(this.ring, qr, qi);
        Complex<Object> Rp = this.subtract(Sp.multiply(S));
        ret[0] = Sp;
        ret[1] = Rp;
        return ret;
    }

    @Override
    public Complex<C> gcd(Complex<C> S) {
        if (S == null || S.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return S;
        }
        if (this.ring.isField()) {
            return this.ring.getONE();
        }
        AbelianGroupElem<Complex<C>> a = this;
        AbelianGroupElem<Complex<C>> b = S;
        if (((Complex)a).re.signum() < 0) {
            a = ((Complex)a).negate();
        }
        if (b.re.signum() < 0) {
            b = b.negate();
        }
        while (!b.isZERO()) {
            Complex<C>[] qr = ((Complex)a).quotientRemainder((Complex<C>)b);
            if (qr[0].isZERO()) {
                // empty if block
            }
            a = b;
            b = qr[1];
        }
        if (((Complex)a).re.signum() < 0) {
            a = ((Complex)a).negate();
        }
        return a;
    }

    public Complex<C>[] egcd(Complex<C> S) {
        Complex[] ret = new Complex[]{null, null, null};
        if (S == null || S.isZERO()) {
            ret[0] = this;
            return ret;
        }
        if (this.isZERO()) {
            ret[0] = S;
            return ret;
        }
        if (this.ring.isField()) {
            Complex<RingElem> half = new Complex<RingElem>(this.ring, (RingElem)((RingElem)this.ring.ring.fromInteger(1L)).divide((MonoidElem)this.ring.ring.fromInteger(2L)));
            ret[0] = this.ring.getONE();
            ret[1] = ((Complex)this.inverse()).multiply(half);
            ret[2] = ((Complex)S.inverse()).multiply(half);
            return ret;
        }
        Complex<C> q = this;
        Complex<C> r = S;
        Element c1 = this.ring.getONE();
        Complex<C> d1 = this.ring.getZERO();
        AbelianGroupElem c2 = this.ring.getZERO();
        Complex<C> d2 = this.ring.getONE();
        while (!r.isZERO()) {
            Complex<C>[] qr = q.quotientRemainder(r);
            q = qr[0];
            Complex<C> x1 = ((Complex)c1).subtract(q.multiply(d1));
            Complex<C> x2 = ((Complex)c2).subtract(q.multiply(d2));
            c1 = d1;
            c2 = d2;
            d1 = x1;
            d2 = x2;
            q = r;
            r = qr[1];
        }
        if (q.re.signum() < 0) {
            q = q.negate();
            c1 = ((Complex)c1).negate();
            c2 = ((Complex)c2).negate();
        }
        ret[0] = q;
        ret[1] = c1;
        ret[2] = c2;
        return ret;
    }
}

