/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations;

import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.transformations.Transformation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class TransformationCollection
implements Transformation {
    private final Transformation[] transformations;

    public TransformationCollection(Collection<Transformation> transformations) {
        this.transformations = transformations.toArray(new Transformation[transformations.size()]);
    }

    public TransformationCollection(Transformation ... transformations) {
        this.transformations = (Transformation[])transformations.clone();
    }

    @Override
    public Tensor transform(Tensor t) {
        for (Transformation tr : this.transformations) {
            t = tr.transform(t);
        }
        return t;
    }

    public List<Transformation> getTransformations() {
        return Collections.unmodifiableList(Arrays.asList(this.transformations));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (true) {
            sb.append(this.transformations[i]);
            if (i == this.transformations.length - 1) break;
            sb.append("\n");
            ++i;
        }
        return sb.toString();
    }
}

