/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.tensor.functions;

import cc.redberry.core.number.Complex;
import cc.redberry.core.number.ComplexUtils;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.TensorBuilder;
import cc.redberry.core.tensor.TensorFactory;
import cc.redberry.core.tensor.Tensors;
import cc.redberry.core.tensor.functions.Exp;
import cc.redberry.core.tensor.functions.ScalarFunction;
import cc.redberry.core.tensor.functions.ScalarFunctionBuilder;
import cc.redberry.core.tensor.functions.ScalarFunctionFactory;
import cc.redberry.core.utils.TensorUtils;

public final class Log
extends ScalarFunction {
    Log(Tensor argument) {
        super(argument);
    }

    @Override
    public Tensor derivative() {
        return Tensors.pow(this.argument, Complex.MINUS_ONE);
    }

    @Override
    protected int hash() {
        return 13 * this.argument.hashCode();
    }

    @Override
    public String functionName() {
        return "Log";
    }

    @Override
    public TensorBuilder getBuilder() {
        return new ScalarFunctionBuilder(LogFactory.FACTORY);
    }

    @Override
    public TensorFactory getFactory() {
        return LogFactory.FACTORY;
    }

    public static final class LogFactory
    extends ScalarFunctionFactory {
        public static final LogFactory FACTORY = new LogFactory();

        private LogFactory() {
        }

        @Override
        public Tensor create1(Tensor arg) {
            if (arg instanceof Exp) {
                return arg.get(0);
            }
            if (TensorUtils.isOne(arg)) {
                return Complex.ZERO;
            }
            if (TensorUtils.isNumeric(arg)) {
                return ComplexUtils.log((Complex)arg);
            }
            return new Log(arg);
        }
    }
}

