/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.tensor.functions;

import cc.redberry.core.number.Complex;
import cc.redberry.core.number.ComplexUtils;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.TensorBuilder;
import cc.redberry.core.tensor.TensorFactory;
import cc.redberry.core.tensor.Tensors;
import cc.redberry.core.tensor.functions.ArcCot;
import cc.redberry.core.tensor.functions.ScalarFunction;
import cc.redberry.core.tensor.functions.ScalarFunctionBuilder;
import cc.redberry.core.tensor.functions.ScalarFunctionFactory;
import cc.redberry.core.tensor.functions.Sin;
import cc.redberry.core.utils.TensorUtils;

public final class Cot
extends ScalarFunction {
    Cot(Tensor argument) {
        super(argument);
    }

    @Override
    public Tensor derivative() {
        return Tensors.pow((Tensor)new Sin(this.argument), Complex.MINUS_TWO);
    }

    @Override
    public String functionName() {
        return "Cot";
    }

    @Override
    protected int hash() {
        return 19 * this.argument.hashCode();
    }

    @Override
    public TensorBuilder getBuilder() {
        return new ScalarFunctionBuilder(CotFactory.FACTORY);
    }

    @Override
    public TensorFactory getFactory() {
        return CotFactory.FACTORY;
    }

    public static final class CotFactory
    extends ScalarFunctionFactory {
        public static final CotFactory FACTORY = new CotFactory();

        private CotFactory() {
        }

        @Override
        public Tensor create1(Tensor arg) {
            if (arg instanceof ArcCot) {
                return arg.get(0);
            }
            if (TensorUtils.isZero(arg)) {
                return Complex.COMPLEX_POSITIVE_INFINITY;
            }
            if (TensorUtils.isNumeric(arg)) {
                return ComplexUtils.cot((Complex)arg);
            }
            return new Cot(arg);
        }
    }
}

