/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.tensor;

import cc.redberry.core.tensor.TensorContraction;
import java.util.Arrays;

public final class StructureOfContractionsHashed {
    public static final StructureOfContractionsHashed EMPTY_INSTANCE = new StructureOfContractionsHashed(new TensorContraction(-1, new long[0]), new TensorContraction[0]);
    private final TensorContraction freeContraction;
    private final TensorContraction[] contractions;

    public StructureOfContractionsHashed(TensorContraction freeContraction, TensorContraction ... contractions) {
        this.freeContraction = freeContraction;
        this.contractions = contractions;
    }

    public TensorContraction get(int i) {
        return this.contractions[i];
    }

    public TensorContraction getFreeContraction() {
        return this.freeContraction;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (this.hashCode() != obj.hashCode()) {
            return false;
        }
        StructureOfContractionsHashed other = (StructureOfContractionsHashed)obj;
        if (!this.freeContraction.equals(other.freeContraction)) {
            return false;
        }
        return Arrays.equals(this.contractions, other.contractions);
    }

    public int hashCode() {
        int hash = 5;
        hash = 67 * hash + this.freeContraction.hashCode();
        hash = 67 * hash + Arrays.hashCode(this.contractions);
        return hash;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Free: ");
        builder.append(this.freeContraction);
        for (TensorContraction contraction : this.contractions) {
            builder.append("\n").append(contraction);
        }
        return builder.toString();
    }
}

