/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.tensor;

import cc.redberry.core.indices.IndicesBuilder;
import cc.redberry.core.indices.IndicesFactory;
import cc.redberry.core.number.Complex;
import cc.redberry.core.tensor.Product;
import cc.redberry.core.tensor.ProductContent;
import cc.redberry.core.tensor.Sum;
import cc.redberry.core.tensor.SumBuilder;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.TensorBuilder;
import cc.redberry.core.tensor.Tensors;
import java.util.Arrays;

public class Split {
    public final Tensor factor;
    public final Tensor summand;

    public Split(Tensor factor, Tensor summand) {
        this.factor = factor;
        this.summand = summand;
    }

    public TensorBuilder getBuilder() {
        SumBuilder builder = new SumBuilder();
        builder.put(this.summand);
        return builder;
    }

    public static Split splitScalars(Tensor tensor) {
        Tensor summand;
        Tensor factor;
        if (tensor.getIndices().getFree().size() == 0) {
            return new SplitNumbers(tensor, Complex.ONE);
        }
        if (tensor instanceof Product) {
            int dataLength;
            Product product = (Product)tensor;
            ProductContent content = product.getContent();
            factor = content.getNonScalar();
            Tensor[] scalars = content.getScalars();
            int n = factor instanceof Product ? product.data.length - ((Product)factor).data.length : (dataLength = product.data.length == 0 ? 0 : product.data.length - 1);
            if (factor == null) {
                factor = Complex.ONE;
            }
            if (dataLength == 0) {
                if (product.indexlessData.length == 0) {
                    summand = product.factor;
                } else if (product.indexlessData.length == 1 && product.factor == Complex.ONE) {
                    summand = product.indexlessData[0];
                } else if (product.factor.isMinusOne() && product.indexlessData.length == 1 && product.indexlessData[0] instanceof Sum) {
                    Sum s = (Sum)product.indexlessData[0];
                    Tensor[] sumData = (Tensor[])s.data.clone();
                    for (int i = sumData.length - 1; i >= 0; --i) {
                        sumData[i] = Tensors.negate(sumData[i]);
                    }
                    summand = new Sum(s.indices, sumData, s.hashCode());
                } else {
                    summand = new Product(product.factor, product.indexlessData, new Tensor[0], ProductContent.EMPTY_INSTANCE, IndicesFactory.EMPTY_INDICES);
                }
            } else if (dataLength == 1 && product.indexlessData.length == 0 && product.factor == Complex.ONE) {
                summand = scalars[0];
            } else {
                Object[] data = new Tensor[dataLength];
                IndicesBuilder ib = new IndicesBuilder();
                dataLength = -1;
                for (Tensor t : scalars) {
                    if (t instanceof Product) {
                        for (Tensor d : t) {
                            data[++dataLength] = d;
                            ib.append(d);
                        }
                        continue;
                    }
                    data[++dataLength] = t;
                    ib.append(t);
                }
                assert (dataLength == data.length - 1);
                Arrays.sort(data);
                summand = new Product(product.factor, product.indexlessData, (Tensor[])data, null, ib.getIndices());
            }
        } else {
            summand = Complex.ONE;
            factor = tensor;
        }
        return new Split(factor, summand);
    }

    public static Split splitIndexless(Tensor tensor) {
        Tensor factor;
        Tensor summand;
        if (tensor.getIndices().size() == 0) {
            Tensor factor2;
            Complex complex;
            if (tensor instanceof Product) {
                Product product = (Product)tensor;
                complex = product.factor;
                factor2 = complex == Complex.ONE ? tensor : (product.size() == 2 ? product.get(1) : new Product(Complex.ONE, product.indexlessData, product.data, product.contentReference.getReferent(), product.indices));
            } else {
                complex = Complex.ONE;
                factor2 = tensor;
            }
            return new SplitNumbers(factor2, complex);
        }
        if (tensor instanceof Product) {
            Product product = (Product)tensor;
            if (product.indexlessData.length == 0) {
                summand = product.factor;
            } else if (product.factor == Complex.ONE && product.indexlessData.length == 1) {
                summand = product.indexlessData[0];
            } else if (product.factor.isMinusOne() && product.indexlessData.length == 1 && product.indexlessData[0] instanceof Sum) {
                Sum s = (Sum)product.indexlessData[0];
                Tensor[] sumData = (Tensor[])s.data.clone();
                for (int i = sumData.length - 1; i >= 0; --i) {
                    sumData[i] = Tensors.negate(sumData[i]);
                }
                summand = new Sum(s.indices, sumData, s.hashCode());
            } else {
                summand = new Product(product.factor, product.indexlessData, new Tensor[0], ProductContent.EMPTY_INSTANCE, IndicesFactory.EMPTY_INDICES);
            }
            factor = product.data.length == 1 ? product.data[0] : new Product(Complex.ONE, new Tensor[0], product.data, product.contentReference.getReferent(), product.indices);
        } else {
            summand = Complex.ONE;
            factor = tensor;
        }
        return new Split(factor, summand);
    }

    public String toString() {
        return this.summand + " * " + this.factor;
    }

    private static final class ComplexSumBuilder
    implements TensorBuilder {
        Complex complex = Complex.ZERO;

        public ComplexSumBuilder() {
        }

        public ComplexSumBuilder(Complex complex) {
            this.complex = complex;
        }

        @Override
        public Tensor build() {
            return this.complex;
        }

        @Override
        public void put(Tensor tensor) {
            this.complex = this.complex.add((Complex)tensor);
        }

        @Override
        public TensorBuilder clone() {
            return new ComplexSumBuilder(this.complex);
        }
    }

    private static class SplitNumbers
    extends Split {
        public SplitNumbers(Tensor factor, Tensor summand) {
            super(factor, summand);
        }

        @Override
        public TensorBuilder getBuilder() {
            ComplexSumBuilder builder = new ComplexSumBuilder();
            builder.put(this.summand);
            return builder;
        }
    }
}

