/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.tensor;

import cc.redberry.core.context.OutputFormat;
import cc.redberry.core.indices.Indices;
import cc.redberry.core.indices.IndicesFactory;
import cc.redberry.core.number.Complex;
import cc.redberry.core.tensor.PowerBuilder;
import cc.redberry.core.tensor.PowerFactory;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.TensorBuilder;
import cc.redberry.core.tensor.TensorFactory;
import cc.redberry.core.utils.TensorUtils;

public final class Power
extends Tensor {
    private final Tensor argument;
    private final Tensor power;

    Power(Tensor a, Tensor power) {
        this.argument = a;
        this.power = power;
    }

    @Override
    public Tensor get(int i) {
        switch (i) {
            case 0: {
                return this.argument;
            }
            case 1: {
                return this.power;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Indices getIndices() {
        return IndicesFactory.EMPTY_INDICES;
    }

    @Override
    protected int hash() {
        return 37 * this.argument.hash() + this.power.hash();
    }

    @Override
    public int size() {
        return 2;
    }

    @Override
    public String toString(OutputFormat mode) {
        if (mode.is(OutputFormat.WolframMathematica)) {
            return "Power[" + this.argument.toString(mode) + ", " + this.power.toString(mode) + "]";
        }
        if (mode.is(OutputFormat.LaTeX)) {
            if (TensorUtils.isRealNegativeNumber(this.power)) {
                return "\\frac{1}{" + this.argument.toString(mode, Power.class) + (TensorUtils.isMinusOne(this.power) ? "" : "^" + ((Complex)this.power).abs().toString(mode)) + "}";
            }
            return this.argument.toString(mode, Power.class) + "^{" + this.power.toString(mode) + "}";
        }
        return this.argument.toString(mode, Power.class) + "**" + this.power.toString(mode, Power.class);
    }

    @Override
    public TensorBuilder getBuilder() {
        return new PowerBuilder();
    }

    @Override
    public TensorFactory getFactory() {
        return PowerFactory.FACTORY;
    }
}

