/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.tensor;

import cc.redberry.core.indices.Indices;
import cc.redberry.core.indices.IndicesFactory;
import cc.redberry.core.tensor.Expression;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.TensorBuilder;
import cc.redberry.core.tensor.TensorException;
import cc.redberry.core.utils.TensorUtils;

public class ExpressionBuilder
implements TensorBuilder {
    private Tensor left;
    private Tensor right;
    private Indices indices;

    public ExpressionBuilder() {
    }

    private ExpressionBuilder(Tensor left, Tensor right, Indices indices) {
        this.left = left;
        this.right = right;
        this.indices = indices;
    }

    @Override
    public Expression build() {
        return new Expression(this.indices, this.left, this.right);
    }

    @Override
    public void put(Tensor tensor) {
        if (tensor == null) {
            throw new NullPointerException();
        }
        if (this.left == null) {
            this.left = tensor;
            this.indices = IndicesFactory.create(this.left.getIndices().getFree());
        } else if (this.right == null) {
            this.right = tensor;
            if (!(TensorUtils.isZero(this.right) || TensorUtils.isIndeterminate(this.right) || this.indices.equalsRegardlessOrder(this.right.getIndices().getFree()))) {
                throw new TensorException("Inconsistent indices in expression.", tensor);
            }
        } else {
            throw new TensorException("Expression have only two parts.");
        }
    }

    @Override
    public TensorBuilder clone() {
        return new ExpressionBuilder(this.left, this.right, this.indices);
    }
}

