/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.tensor;

import cc.redberry.core.context.OutputFormat;
import cc.redberry.core.indices.Indices;
import cc.redberry.core.tensor.ExpressionBuilder;
import cc.redberry.core.tensor.ExpressionFactory;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.TensorBuilder;
import cc.redberry.core.tensor.TensorFactory;
import cc.redberry.core.transformations.Transformation;
import cc.redberry.core.transformations.substitutions.SubstitutionTransformation;
import cc.redberry.core.utils.TensorUtils;

public class Expression
extends Tensor
implements Transformation {
    private final Tensor right;
    private final Tensor left;
    private final Indices indices;

    Expression(Indices indices, Tensor left, Tensor right) {
        this.indices = indices;
        this.right = right;
        this.left = left;
    }

    @Override
    public Tensor get(int i) {
        switch (i) {
            case 0: {
                return this.left;
            }
            case 1: {
                return this.right;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Indices getIndices() {
        return this.indices;
    }

    @Override
    protected int hash() {
        return 3 * this.left.hashCode() - 7 * this.right.hashCode();
    }

    @Override
    public int size() {
        return 2;
    }

    @Override
    public String toString(OutputFormat mode) {
        return this.left.toString(mode) + " = " + this.right.toString(mode);
    }

    @Override
    public TensorBuilder getBuilder() {
        return new ExpressionBuilder();
    }

    @Override
    public TensorFactory getFactory() {
        return ExpressionFactory.FACTORY;
    }

    @Override
    public Tensor transform(Tensor t) {
        return new SubstitutionTransformation(this).transform(t);
    }

    public boolean isIdentity() {
        return TensorUtils.equals(this.left, this.right);
    }

    public Expression transpose() {
        return new Expression(this.indices, this.right, this.left);
    }
}

