/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.solver.frobenius;

import cc.redberry.core.solver.frobenius.SolutionProvider;
import cc.redberry.core.solver.frobenius.SolutionProviderAbstract;

final class FinalSolutionProvider
extends SolutionProviderAbstract {
    public FinalSolutionProvider(SolutionProvider provider, int position, int[] coefficient) {
        super(provider, position, coefficient);
    }

    @Override
    public int[] take() {
        if (this.currentSolution == null) {
            return null;
        }
        int i = 0;
        while (i < this.coefficients.length && this.coefficients[i++] == 0) {
        }
        assert (--i == 0 || i != this.coefficients.length);
        if (this.currentRemainder[i] % this.coefficients[i] != 0) {
            this.currentSolution = null;
            return null;
        }
        this.currentCounter = this.currentRemainder[i] / this.coefficients[i];
        for (i = 0; i < this.coefficients.length; ++i) {
            if (this.coefficients[i] == 0) {
                if (this.currentRemainder[i] == 0) continue;
                this.currentSolution = null;
                return null;
            }
            if (this.currentRemainder[i] % this.coefficients[i] != 0) {
                this.currentSolution = null;
                return null;
            }
            if (this.currentRemainder[i] / this.coefficients[i] == this.currentCounter) continue;
            this.currentSolution = null;
            return null;
        }
        int[] solution = (int[])this.currentSolution.clone();
        int n = this.position;
        solution[n] = solution[n] + this.currentCounter;
        this.currentSolution = null;
        return solution;
    }
}

