/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.parser.preprocessor;

import cc.redberry.core.context.NameAndStructureOfIndices;
import cc.redberry.core.indices.IndicesFactory;
import cc.redberry.core.indices.IndicesUtils;
import cc.redberry.core.indices.SimpleIndices;
import cc.redberry.core.parser.ParseToken;
import cc.redberry.core.parser.ParseTokenExpression;
import cc.redberry.core.parser.ParseTokenScalarFunction;
import cc.redberry.core.parser.ParseTokenSimpleTensor;
import cc.redberry.core.parser.ParseTokenTensorField;
import cc.redberry.core.parser.ParseTokenTransformer;
import cc.redberry.core.parser.TokenType;
import cc.redberry.core.parser.preprocessor.TypesAndNamesTransformer;

public class ChangeIndicesTypesAndTensorNames
implements ParseTokenTransformer {
    private final TypesAndNamesTransformer transformer;

    public ChangeIndicesTypesAndTensorNames(TypesAndNamesTransformer transformer) {
        this.transformer = transformer;
    }

    @Override
    public ParseToken transform(ParseToken node) {
        TokenType type = node.tokenType;
        switch (type) {
            case SimpleTensor: {
                ParseTokenSimpleTensor st = (ParseTokenSimpleTensor)node;
                return new ParseTokenSimpleTensor(this.transformIndices(st.getIndices(), st.getIndicesTypeStructureAndName()), this.transformer.newName(st.getIndicesTypeStructureAndName()));
            }
            case TensorField: {
                ParseTokenTensorField tf = (ParseTokenTensorField)node;
                ParseToken[] newContent = this.transformContent(tf.content);
                SimpleIndices[] newArgsIndices = new SimpleIndices[tf.argumentsIndices.length];
                for (int i = newArgsIndices.length - 1; i >= 0; --i) {
                    newArgsIndices[i] = IndicesFactory.createSimple(null, newContent[i].getIndices());
                }
                return new ParseTokenTensorField(this.transformIndices(tf.getIndices(), tf.getIndicesTypeStructureAndName()), this.transformer.newName(tf.getIndicesTypeStructureAndName()), newContent, newArgsIndices);
            }
            case Number: {
                return node;
            }
            case ScalarFunction: {
                return new ParseTokenScalarFunction(((ParseTokenScalarFunction)node).function, this.transformContent(node.content));
            }
            case Expression: {
                ParseToken[] nContent = this.transformContent(node.content);
                return new ParseTokenExpression(((ParseTokenExpression)node).preprocess, nContent[0], nContent[1]);
            }
        }
        return new ParseToken(node.tokenType, this.transformContent(node.content));
    }

    private ParseToken[] transformContent(ParseToken[] content) {
        ParseToken[] newContent = new ParseToken[content.length];
        for (int i = content.length - 1; i >= 0; --i) {
            newContent[i] = this.transform(content[i]);
        }
        return newContent;
    }

    private SimpleIndices transformIndices(SimpleIndices old, NameAndStructureOfIndices oldDescriptor) {
        int[] newIndices = new int[old.size()];
        for (int i = old.size() - 1; i >= 0; --i) {
            newIndices[i] = IndicesUtils.setType(this.transformer.newType(IndicesUtils.getTypeEnum(old.get(i)), oldDescriptor), old.get(i));
        }
        return IndicesFactory.createSimple(null, newIndices);
    }
}

