/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.parser;

import cc.redberry.core.number.Complex;
import cc.redberry.core.parser.ParseToken;
import cc.redberry.core.parser.ParseTokenNumber;
import cc.redberry.core.parser.ParserOperator;
import cc.redberry.core.parser.TokenType;
import java.util.List;

public class ParserSum
extends ParserOperator {
    public static final ParserSum INSTANCE = new ParserSum();

    private ParserSum() {
        super('+', '-');
    }

    @Override
    protected ParseToken compile(List<ParseToken> nodes) {
        return new ParseToken(TokenType.Sum, nodes.toArray(new ParseToken[nodes.size()]));
    }

    @Override
    protected ParseToken inverseOperation(ParseToken node) {
        ParseToken[] content;
        if (node.tokenType == TokenType.Product) {
            content = new ParseToken[1 + node.content.length];
            content[0] = new ParseTokenNumber(Complex.MINUS_ONE);
            System.arraycopy(node.content, 0, content, 1, node.content.length);
        } else {
            content = new ParseToken[]{new ParseTokenNumber(Complex.MINUS_ONE), node};
        }
        return new ParseToken(TokenType.Product, content);
    }

    @Override
    public int priority() {
        return 1000;
    }
}

