/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.parser;

import cc.redberry.core.parser.ParseToken;
import cc.redberry.core.parser.ParseTokenDerivative;
import cc.redberry.core.parser.ParseUtils;
import cc.redberry.core.parser.Parser;
import cc.redberry.core.parser.TokenParser;
import cc.redberry.core.parser.TokenType;
import java.util.ArrayList;

public class ParserDerivative
implements TokenParser {
    public static final ParserDerivative INSTANCE = new ParserDerivative();

    private ParserDerivative() {
    }

    @Override
    public ParseToken parseToken(String expression, Parser parser) {
        if (!expression.contains("][") || !expression.substring(0, 2).equals("D[") || expression.charAt(expression.length() - 1) != ']') {
            return null;
        }
        String[] parts = expression.split("\\]\\[");
        if (parts.length != 2) {
            return null;
        }
        String argStr = parts[1].substring(0, parts[1].length() - 1);
        if (!ParseUtils.checkBracketsConsistence(argStr)) {
            return null;
        }
        ParseToken arg = parser.parse(argStr);
        if (arg == null) {
            return null;
        }
        char[] chars = parts[0].substring(2).toCharArray();
        int[] levels = new int[2];
        StringBuilder buffer = new StringBuilder();
        ArrayList<ParseToken> tokens = new ArrayList<ParseToken>();
        tokens.add(arg);
        for (int i = 0; i < chars.length; ++i) {
            if (levels[0] < 0 || levels[1] < 0) {
                return null;
            }
            char c = chars[i];
            if (c == '(') {
                levels[0] = levels[0] + 1;
                continue;
            }
            if (c == '[') {
                levels[1] = levels[1] + 1;
                continue;
            }
            if (c == ')') {
                levels[0] = levels[0] - 1;
                continue;
            }
            if (c == ']') {
                levels[1] = levels[1] - 1;
                continue;
            }
            if (c == ',' && levels[0] == 0 && levels[1] == 0) {
                tokens.add(parser.parse(buffer.toString()));
                buffer = new StringBuilder();
                continue;
            }
            buffer.append(c);
        }
        if (levels[0] != 0 || levels[1] != 0) {
            return null;
        }
        tokens.add(parser.parse(buffer.toString()));
        return new ParseTokenDerivative(TokenType.Derivative, tokens.toArray(new ParseToken[tokens.size()]));
    }

    @Override
    public int priority() {
        return 8000;
    }
}

