/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.parser;

import cc.redberry.core.parser.ParseToken;
import cc.redberry.core.parser.ParseTokenTransformer;
import cc.redberry.core.parser.Parser;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.transformations.Transformation;
import java.util.ArrayList;
import java.util.List;

public final class ParseManager {
    public List<ParseTokenTransformer> defaultParserPreprocessors = new ArrayList<ParseTokenTransformer>();
    public List<Transformation> defaultTensorPreprocessors = new ArrayList<Transformation>();
    private final Parser parser;

    public ParseManager(Parser parser) {
        this.parser = parser;
    }

    public Tensor parse(String expression, Transformation[] tensorPreprocessors, ParseTokenTransformer[] nodesPreprocessors) {
        ParseToken node = this.parser.parse(expression);
        for (ParseTokenTransformer tr : nodesPreprocessors) {
            node = tr.transform(node);
        }
        Tensor t = node.toTensor();
        for (Transformation tr : tensorPreprocessors) {
            if (tr == t) continue;
            t = tr.transform(t);
        }
        return t;
    }

    public Tensor parse(String expression, List<Transformation> tensorPreprocessors, List<ParseTokenTransformer> nodesPreprocessors) {
        ParseToken node = this.parser.parse(expression);
        for (ParseTokenTransformer tr : nodesPreprocessors) {
            node = tr.transform(node);
        }
        Tensor t = node.toTensor();
        for (Transformation tr : tensorPreprocessors) {
            if (tr == t) continue;
            t = tr.transform(t);
        }
        return t;
    }

    public Tensor parse(String expression, ParseTokenTransformer ... nodesPreprocessors) {
        return this.parse(expression, new Transformation[0], nodesPreprocessors);
    }

    public Tensor parse(String expression) {
        return this.parse(expression, this.defaultTensorPreprocessors, this.defaultParserPreprocessors);
    }

    public Parser getParser() {
        return this.parser;
    }
}

