/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.number;

import cc.redberry.core.number.Number;
import cc.redberry.core.number.NumberUtils;
import cc.redberry.core.number.Numeric;
import cc.redberry.core.number.Real;
import java.io.Serializable;
import java.math.BigInteger;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.fraction.BigFraction;
import org.apache.commons.math3.fraction.FractionConversionException;

public final class Rational
extends Real
implements Serializable {
    public static final Rational TWO = new Rational(2);
    public static final Rational FOUR = new Rational(4);
    public static final Rational MINUS_TWO = new Rational(-2);
    public static final Rational ONE = new Rational(1);
    public static final Rational ZERO = new Rational(0);
    public static final Rational MINUS_ONE = new Rational(-1);
    public static final Rational FOUR_FIFTHS = new Rational(4, 5);
    public static final Rational ONE_FIFTH = new Rational(1, 5);
    public static final Rational ONE_HALF = new Rational(1, 2);
    public static final Rational MINUSE_ONE_HALF = new Rational(-1, 2);
    public static final Rational ONE_QUARTER = new Rational(1, 4);
    public static final Rational ONE_THIRD = new Rational(1, 3);
    public static final Rational THREE_FIFTHS = new Rational(3, 5);
    public static final Rational THREE_QUARTERS = new Rational(3, 4);
    public static final Rational TWO_FIFTHS = new Rational(2, 5);
    public static final Rational TWO_THIRDS = new Rational(2, 3);
    public static final BigFraction BIG_FRACTION_MAX_DOUBLE = new BigFraction(Double.MAX_VALUE);
    public static final BigFraction BIG_FRACTION_MIN_DOUBLE = new BigFraction(-1.7976931348623157E308);
    public static final BigFraction BIG_FRACTION_MAX_INTEGER = new BigFraction(Integer.MAX_VALUE);
    public static final BigFraction BIG_FRACTION_MIN_INTEGER = new BigFraction(Integer.MIN_VALUE);
    public static final BigFraction BIG_FRACTION_MAX_LONG = new BigFraction(Long.MAX_VALUE);
    public static final BigFraction BIG_FRACTION_MIN_LONG = new BigFraction(Long.MIN_VALUE);
    private static final long serialVersionUID = -5630213147331578515L;
    private final BigFraction fraction;
    private static final BigInteger BI_MINUS_ONE = new BigInteger("-1");

    public Rational(BigFraction fraction) {
        NumberUtils.checkNotNull(fraction);
        this.fraction = fraction;
    }

    public Rational(BigInteger num) {
        NumberUtils.checkNotNull(num);
        this.fraction = new BigFraction(num);
    }

    public Rational(BigInteger num, BigInteger den) {
        NumberUtils.checkNotNull(num);
        NumberUtils.checkNotNull(den);
        this.fraction = new BigFraction(num, den);
    }

    public Rational(double value) throws MathIllegalArgumentException {
        this.fraction = new BigFraction(value);
    }

    public Rational(double value, double epsilon, int maxIterations) throws FractionConversionException {
        this.fraction = new BigFraction(value, epsilon, maxIterations);
    }

    public Rational(double value, int maxDenominator) throws FractionConversionException {
        this.fraction = new BigFraction(value, maxDenominator);
    }

    public Rational(int num) {
        this.fraction = new BigFraction(num);
    }

    public Rational(int num, int den) {
        this.fraction = new BigFraction(num, den);
    }

    public Rational(long num) {
        this.fraction = new BigFraction(num);
    }

    public Rational(long num, long den) {
        this.fraction = new BigFraction(num, den);
    }

    public BigFraction getBigFraction() {
        return this.fraction;
    }

    @Override
    public long longValue() {
        if (this.fraction.compareTo(BIG_FRACTION_MAX_LONG) > 0 || this.fraction.compareTo(BIG_FRACTION_MIN_LONG) < 0) {
            throw new RuntimeException("Long overflow.");
        }
        return this.fraction.longValue();
    }

    @Override
    public int intValue() {
        if (this.fraction.compareTo(BIG_FRACTION_MAX_INTEGER) > 0 || this.fraction.compareTo(BIG_FRACTION_MIN_INTEGER) < 0) {
            throw new RuntimeException("Integer overflow.");
        }
        return this.fraction.intValue();
    }

    @Override
    public BigInteger bigIntValue() {
        return this.fraction.getNumerator().divide(this.fraction.getDenominator());
    }

    @Override
    public float floatValue() {
        return this.fraction.floatValue();
    }

    @Override
    public double doubleValue() {
        if (this.fraction.compareTo(BIG_FRACTION_MAX_DOUBLE) > 0 || this.fraction.compareTo(BIG_FRACTION_MIN_DOUBLE) < 0) {
            throw new RuntimeException("Double overflow.");
        }
        return this.fraction.doubleValue();
    }

    public int hashCode() {
        return this.fraction.abs().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Number)) {
            return false;
        }
        if (obj instanceof Rational) {
            return this.fraction.equals((Object)((Rational)obj).fraction);
        }
        return ((Numeric)obj).doubleValue() == this.doubleValue();
    }

    public String toString() {
        return this.fraction.getNumerator().toString() + (this.fraction.getDenominator().equals(BigInteger.ONE) ? "" : "/" + this.fraction.getDenominator().toString());
    }

    @Override
    public boolean isInfinite() {
        return false;
    }

    @Override
    public boolean isNaN() {
        return false;
    }

    public Real add(Real arg0) {
        NumberUtils.checkNotNull(arg0);
        if (arg0 instanceof Numeric) {
            return (Real)arg0.add(this);
        }
        return NumberUtils.createRational(this.fraction.add(((Rational)arg0).fraction));
    }

    public Real divide(Real arg0) {
        NumberUtils.checkNotNull(arg0);
        if (arg0 instanceof Numeric || arg0.isZero()) {
            return NumberUtils.createNumeric(this.fraction.doubleValue() / arg0.doubleValue());
        }
        return NumberUtils.createRational(this.fraction.divide(((Rational)arg0).fraction));
    }

    @Override
    public Real multiply(double d) {
        return NumberUtils.createNumeric(d * this.fraction.doubleValue());
    }

    public Rational multiply(int arg0) {
        return arg0 == 1 ? this : (arg0 == 0 ? ZERO : new Rational(this.fraction.multiply(arg0)));
    }

    public Real multiply(Real arg0) {
        NumberUtils.checkNotNull(arg0);
        if (arg0 instanceof Numeric) {
            return (Real)arg0.multiply(this);
        }
        return arg0.isOne() ? this : (arg0.isZero() ? ZERO : NumberUtils.createRational(this.fraction.multiply(((Rational)arg0).fraction)));
    }

    public Rational multiply(Rational arg0) {
        NumberUtils.checkNotNull(arg0);
        return arg0.isOne() ? this : (arg0.isZero() ? ZERO : NumberUtils.createRational(this.fraction.multiply(arg0.fraction)));
    }

    public Rational negate() {
        return NumberUtils.createRational(this.fraction.negate());
    }

    public Rational reciprocal() {
        return NumberUtils.createRational(this.fraction.reciprocal());
    }

    public Real subtract(Real arg0) {
        NumberUtils.checkNotNull(arg0);
        if (arg0 instanceof Numeric) {
            return new Numeric(this.fraction.doubleValue() - arg0.doubleValue());
        }
        return NumberUtils.createRational(this.fraction.subtract(((Rational)arg0).fraction));
    }

    @Override
    public Rational subtract(BigFraction fraction) {
        NumberUtils.checkNotNull(fraction);
        return NumberUtils.createRational(this.fraction.subtract(fraction));
    }

    @Override
    public Rational subtract(long l) {
        return l == 0L ? this : NumberUtils.createRational(this.fraction.subtract(l));
    }

    @Override
    public Rational subtract(int i) {
        return new Rational(this.fraction.subtract(i));
    }

    @Override
    public Rational subtract(BigInteger bg) {
        NumberUtils.checkNotNull(bg);
        return new Rational(this.fraction.subtract(bg));
    }

    public Rational reduce() {
        return new Rational(this.fraction.reduce());
    }

    @Override
    public Numeric pow(double exponent) {
        return new Numeric(this.fraction.pow(exponent));
    }

    @Override
    public Rational pow(BigInteger exponent) {
        NumberUtils.checkNotNull(exponent);
        return new Rational(this.fraction.pow(exponent));
    }

    @Override
    public Rational pow(long exponent) {
        return new Rational(this.fraction.pow(exponent));
    }

    @Override
    public Rational pow(int exponent) {
        return new Rational(this.fraction.pow(exponent));
    }

    public double percentageValue() {
        return this.fraction.percentageValue();
    }

    @Override
    public Rational multiply(BigFraction fraction) {
        NumberUtils.checkNotNull(fraction);
        return new Rational(fraction.multiply(fraction));
    }

    @Override
    public Rational multiply(long l) {
        return new Rational(this.fraction.multiply(l));
    }

    @Override
    public Rational multiply(BigInteger bg) {
        NumberUtils.checkNotNull(bg);
        return new Rational(this.fraction.multiply(bg));
    }

    public long getNumeratorAsLong() {
        return this.fraction.getNumeratorAsLong();
    }

    public int getNumeratorAsInt() {
        return this.fraction.getNumeratorAsInt();
    }

    public BigInteger getNumerator() {
        return this.fraction.getNumerator();
    }

    public long getDenominatorAsLong() {
        return this.fraction.getDenominatorAsLong();
    }

    public int getDenominatorAsInt() {
        return this.fraction.getDenominatorAsInt();
    }

    public BigInteger getDenominator() {
        return this.fraction.getDenominator();
    }

    @Override
    public Rational divide(BigFraction fraction) {
        NumberUtils.checkNotNull(fraction);
        return new Rational(fraction.divide(fraction));
    }

    @Override
    public Rational divide(long l) {
        return new Rational(this.fraction.divide(l));
    }

    @Override
    public Rational divide(int i) {
        return new Rational(this.fraction.divide(i));
    }

    @Override
    public Rational divide(BigInteger bg) {
        NumberUtils.checkNotNull(bg);
        return new Rational(this.fraction.divide(bg));
    }

    @Override
    public Real divide(double d) {
        return new Numeric(this.fraction.doubleValue() / d);
    }

    @Override
    public Rational add(BigFraction fraction) {
        NumberUtils.checkNotNull(fraction);
        return new Rational(fraction.add(fraction));
    }

    @Override
    public Rational add(long l) {
        return new Rational(this.fraction.add(l));
    }

    @Override
    public Rational add(BigInteger bg) {
        NumberUtils.checkNotNull(bg);
        return new Rational(this.fraction.add(bg));
    }

    @Override
    public Real add(double d) {
        return new Numeric(d + this.doubleValue());
    }

    @Override
    public Rational add(int i) {
        return new Rational(this.fraction.add(i));
    }

    @Override
    public Real subtract(double d) {
        return new Numeric(this.doubleValue() - d);
    }

    @Override
    public Rational abs() {
        return new Rational(this.fraction.abs());
    }

    @Override
    public Numeric getNumericValue() {
        return new Numeric(this.doubleValue());
    }

    @Override
    public int compareTo(Real o) {
        NumberUtils.checkNotNull(o);
        if (o instanceof Numeric) {
            return Double.compare(this.doubleValue(), o.doubleValue());
        }
        return this.fraction.compareTo(((Rational)o).fraction);
    }

    @Override
    public boolean isNumeric() {
        return false;
    }

    @Override
    public boolean isZero() {
        return this.fraction.getNumerator().equals(BigInteger.ZERO);
    }

    @Override
    public boolean isOne() {
        return this.fraction.getNumerator().equals(BigInteger.ONE) && this.fraction.getDenominator().equals(BigInteger.ONE);
    }

    @Override
    public boolean isMinusOne() {
        return this.fraction.getNumerator().equals(BI_MINUS_ONE) && this.fraction.getDenominator().equals(BigInteger.ONE);
    }

    @Override
    public int signum() {
        return this.fraction.getNumerator().signum();
    }

    @Override
    public boolean isInteger() {
        return this.fraction.getDenominator().compareTo(BigInteger.ONE) == 0;
    }

    @Override
    public boolean isNatural() {
        return this.fraction.getNumerator().signum() >= 0 && this.isInteger();
    }
}

