/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.number;

import cc.redberry.core.number.Complex;
import cc.redberry.core.number.Numeric;
import cc.redberry.core.number.Rational;
import cc.redberry.core.number.Real;
import java.math.BigInteger;
import org.apache.commons.math3.util.ArithmeticUtils;

public final class Exponentiation {
    private static BigInteger BI_MINUS_ONE = BigInteger.ONE.negate();

    public static Real exponentiateIfPossible(Real base, Real power) {
        if (base.isZero()) {
            if (power.isInfinite()) {
                return Numeric.NaN;
            }
            return Rational.ZERO;
        }
        if (base.isNumeric() || power.isNumeric()) {
            return new Numeric(Math.pow(((Real)base.getNumericValue()).doubleValue(), ((Real)power.getNumericValue()).doubleValue()));
        }
        if (power.isInteger()) {
            return new Rational(((Rational)base).getBigFraction().pow(((Rational)power).getNumerator()));
        }
        BigInteger powerNum = ((Rational)power).getNumerator();
        BigInteger powerDen = ((Rational)power).getDenominator();
        BigInteger baseNum = ((Rational)base).getNumerator();
        BigInteger baseDen = ((Rational)base).getDenominator();
        baseNum = Exponentiation.findIntegerRoot(baseNum, powerDen);
        baseDen = Exponentiation.findIntegerRoot(baseDen, powerDen);
        if (baseNum == null || baseDen == null) {
            return null;
        }
        return Exponentiation.exponentiateIfPossible(new Rational(baseNum, baseDen), new Rational(powerNum));
    }

    static BigInteger findIntegerRoot(BigInteger base, BigInteger power) {
        BigInteger maxBits = BigInteger.valueOf(base.bitLength() + 1);
        BigInteger[] divResult = maxBits.divideAndRemainder(power);
        maxBits = divResult[1].signum() == 0 ? divResult[0] : divResult[0].add(BigInteger.ONE);
        if (maxBits.bitLength() > 31) {
            throw new RuntimeException("Too many bits...");
        }
        int targetBitsNumber = maxBits.intValue();
        int resultLengthM1 = targetBitsNumber / 8 + 1;
        byte[] result = new byte[resultLengthM1];
        --resultLengthM1;
        int bitNumber = targetBitsNumber;
        while (--bitNumber >= 0) {
            int n = resultLengthM1 - (bitNumber >> 3);
            result[n] = (byte)(result[n] | 1 << (bitNumber & 7));
            BigInteger testValue = new BigInteger(result);
            int cValue = ArithmeticUtils.pow((BigInteger)testValue, (BigInteger)power).compareTo(base);
            if (cValue == 0) {
                return testValue;
            }
            if (cValue <= 0) continue;
            int n2 = resultLengthM1 - (bitNumber >> 3);
            result[n2] = (byte)(result[n2] & ~(1 << (bitNumber & 7)));
        }
        return null;
    }

    public static Complex exponentiateIfPossible(Complex base, Complex power) {
        if (base.isInfinite()) {
            if (power.isZero()) {
                return Complex.ComplexNaN;
            }
            return base;
        }
        if (base.isOne()) {
            if (power.isInfinite()) {
                return power.multiply(base);
            }
            return base;
        }
        if (power.isOne()) {
            return base;
        }
        if (base.isZero()) {
            if (power.getReal().signum() <= 0) {
                return Complex.ComplexNaN;
            }
            return base;
        }
        if (power.isZero()) {
            return Complex.ONE;
        }
        if (base.isNumeric() || power.isNumeric()) {
            return base.powNumeric(power);
        }
        if (power.isReal()) {
            Rational pp = (Rational)power.getReal();
            if (base.isReal()) {
                Real value = Exponentiation.exponentiateIfPossible(base.getReal(), pp);
                if (value == null) {
                    return null;
                }
                return new Complex(value);
            }
            if (pp.isInteger()) {
                return base.pow(pp.getNumerator());
            }
            Complex root = Exponentiation.findIntegerRoot(base, pp.getDenominator());
            if (root == null) {
                return null;
            }
            return root.pow(pp.getNumerator());
        }
        return null;
    }

    public static Complex findIntegerRoot(Complex base, BigInteger power) {
        BigInteger rDenominator = ((Rational)base.getReal()).getDenominator();
        BigInteger iDenominator = ((Rational)base.getImaginary()).getDenominator();
        BigInteger lcm = rDenominator.gcd(iDenominator);
        lcm = rDenominator.divide(lcm);
        lcm = lcm.multiply(iDenominator);
        BigInteger lcmRoot = Exponentiation.findIntegerRoot(lcm, power);
        if (lcm == null) {
            return null;
        }
        base = base.multiply(lcm);
        Complex numericValue = base.pow(1.0 / power.doubleValue());
        double real = numericValue.getReal().doubleValue();
        double imaginary = numericValue.getImaginary().doubleValue();
        int ceilReal = (int)Math.ceil(real);
        int floorReal = (int)Math.floor(real);
        int ceilImaginary = (int)Math.ceil(imaginary);
        int floorImaginary = (int)Math.floor(imaginary);
        Complex candidate = new Complex(ceilReal, ceilImaginary);
        if (candidate.pow(power).equals(base)) {
            return candidate.divide(lcmRoot);
        }
        candidate = new Complex(floorReal, ceilImaginary);
        if (candidate.pow(power).equals(base)) {
            return candidate.divide(lcmRoot);
        }
        candidate = new Complex(ceilReal, floorImaginary);
        if (candidate.pow(power).equals(base)) {
            return candidate.divide(lcmRoot);
        }
        candidate = new Complex(floorReal, floorImaginary);
        if (candidate.pow(power).equals(base)) {
            return candidate.divide(lcmRoot);
        }
        return null;
    }
}

