/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.indices;

import cc.redberry.core.context.CC;
import cc.redberry.core.indices.IndexType;
import cc.redberry.core.indices.IndicesUtils;
import cc.redberry.core.indices.SimpleIndices;
import cc.redberry.core.utils.BitArray;
import java.util.Arrays;

public final class StructureOfIndices {
    private final int[] typesCounts = new int[8];
    private final BitArray[] states = new BitArray[8];
    private final int size;
    private static StructureOfIndices EMPTY;

    private StructureOfIndices() {
        this.size = 0;
        for (int i = 0; i < 8; ++i) {
            if (CC.isMetric((byte)i)) continue;
            this.states[i] = BitArray.EMPTY;
        }
    }

    private StructureOfIndices(int size) {
        this.size = size;
    }

    private StructureOfIndices(byte type, int count, boolean ... states) {
        this.typesCounts[type] = count;
        this.size = count;
        for (byte i = 0; i < 8; ++i) {
            if (CC.isMetric(i)) continue;
            this.states[i] = i == type ? new BitArray(states) : BitArray.EMPTY;
        }
    }

    private StructureOfIndices(byte type, int count) {
        if (!CC.isMetric(type)) {
            throw new IllegalArgumentException("No states information provided for non metric type.");
        }
        this.typesCounts[type] = count;
        this.size = count;
        for (int i = 0; i < 8; ++i) {
            if (CC.isMetric((byte)i)) continue;
            this.states[i] = BitArray.EMPTY;
        }
    }

    private StructureOfIndices(byte[] types, int[] count) {
        int i;
        for (int i2 = 0; i2 < types.length; ++i2) {
            if (count[i2] == 0 || CC.isMetric(types[i2])) continue;
            throw new IllegalArgumentException("No states information provided for non metric type.");
        }
        int size = 0;
        for (i = 0; i < types.length; ++i) {
            this.typesCounts[types[i]] = count[i];
            size += count[i];
        }
        this.size = size;
        for (i = 0; i < 8; ++i) {
            if (CC.isMetric((byte)i)) continue;
            this.states[i] = BitArray.EMPTY;
        }
    }

    private StructureOfIndices(int[] allCount, BitArray[] allStates) {
        if (allCount.length != 8 || allStates.length != 8) {
            throw new IllegalArgumentException();
        }
        int size = 0;
        for (int i = 0; i < 8; ++i) {
            if (allStates[i] != null && CC.isMetric((byte)i) || allStates[i] == null && !CC.isMetric((byte)i)) {
                throw new IllegalArgumentException();
            }
            this.states[i] = allStates[i] == null ? null : allStates[i].clone();
            size += allCount[i];
        }
        System.arraycopy(allCount, 0, this.typesCounts, 0, allCount.length);
        this.size = size;
    }

    private StructureOfIndices(SimpleIndices indices) {
        int i;
        this.size = indices.size();
        for (i = 0; i < this.size; ++i) {
            byte by = IndicesUtils.getType(indices.get(i));
            this.typesCounts[by] = this.typesCounts[by] + 1;
        }
        int[] pointers = new int[8];
        for (i = 0; i < 8; ++i) {
            if (!CC.isMetric((byte)i)) {
                this.states[i] = StructureOfIndices.createBBBA(this.typesCounts[i]);
                continue;
            }
            pointers[i] = -1;
        }
        for (i = 0; i < this.size; ++i) {
            byte type = IndicesUtils.getType(indices.get(i));
            if (pointers[type] == -1) continue;
            if (IndicesUtils.getState(indices.get(i))) {
                this.states[type].set(pointers[type]);
            }
            byte by = type;
            pointers[by] = pointers[by] + 1;
        }
    }

    public static StructureOfIndices create(byte type, int count, boolean ... states) {
        if (count != states.length) {
            throw new IllegalArgumentException();
        }
        if (count == 0) {
            return StructureOfIndices.getEmpty();
        }
        return new StructureOfIndices(type, count, states);
    }

    public static StructureOfIndices create(byte type, int count) {
        if (count == 0) {
            return StructureOfIndices.getEmpty();
        }
        return new StructureOfIndices(type, count);
    }

    public static StructureOfIndices create(IndexType type, int count) {
        return StructureOfIndices.create(type.getType(), count);
    }

    public static StructureOfIndices create(byte[] types, int[] count) {
        int total = 0;
        for (int i = 0; i < count.length; ++i) {
            total += count[i];
        }
        if (total == 0) {
            return StructureOfIndices.getEmpty();
        }
        return new StructureOfIndices(types, count);
    }

    public static StructureOfIndices create(int[] allCount, BitArray[] allStates) {
        int total = 0;
        for (int i = 0; i < allCount.length; ++i) {
            if (allStates[i] != null && allCount[i] != allStates[i].size()) {
                throw new IllegalArgumentException("Count differs from states size.");
            }
            total += allCount[i];
        }
        if (total == 0) {
            return StructureOfIndices.getEmpty();
        }
        return new StructureOfIndices(allCount, allStates);
    }

    public static StructureOfIndices create(SimpleIndices indices) {
        if (indices.size() == 0) {
            return StructureOfIndices.getEmpty();
        }
        return new StructureOfIndices(indices);
    }

    public BitArray[] getStates() {
        BitArray[] statesCopy = new BitArray[this.states.length];
        for (int i = 0; i < this.states.length; ++i) {
            statesCopy[i] = this.states[i] == null ? null : this.states[i].clone();
        }
        return statesCopy;
    }

    public BitArray getStates(IndexType type) {
        return this.states[type.getType()].clone();
    }

    public boolean fixedStates(IndexType type) {
        return this.states[type.getType()] != null;
    }

    public int[] getTypesCounts() {
        return (int[])this.typesCounts.clone();
    }

    StructureOfIndices(int[] indices) {
        int i;
        this.size = indices.length;
        for (i = 0; i < this.size; ++i) {
            byte by = IndicesUtils.getType(indices[i]);
            this.typesCounts[by] = this.typesCounts[by] + 1;
        }
        int[] pointers = new int[8];
        for (i = 0; i < 8; ++i) {
            if (!CC.isMetric((byte)i)) {
                this.states[i] = StructureOfIndices.createBBBA(this.typesCounts[i]);
                continue;
            }
            pointers[i] = -1;
        }
        for (i = 0; i < this.size; ++i) {
            byte type = IndicesUtils.getType(indices[i]);
            if (pointers[type] == -1) continue;
            if (IndicesUtils.getState(indices[i])) {
                this.states[type].set(pointers[type]);
            }
            byte by = type;
            pointers[by] = pointers[by] + 1;
        }
    }

    private static BitArray createBBBA(int size) {
        if (size == 0) {
            return BitArray.EMPTY;
        }
        return new BitArray(size);
    }

    public int size() {
        return this.size;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StructureOfIndices other = (StructureOfIndices)obj;
        if (this.size != other.size()) {
            return false;
        }
        if (this.size == 0) {
            return true;
        }
        return Arrays.equals(this.typesCounts, other.typesCounts) && Arrays.deepEquals(this.states, other.states);
    }

    public int hashCode() {
        return 469 + Arrays.hashCode(this.typesCounts) + Arrays.hashCode(this.states);
    }

    public TypeData getTypeData(byte type) {
        int from = 0;
        for (int i = 0; i < type; ++i) {
            from += this.typesCounts[i];
        }
        return new TypeData(from, this.typesCounts[type], this.states[type]);
    }

    public int typeCount(byte type) {
        return this.typesCounts[type];
    }

    public boolean isStructureOf(SimpleIndices indices) {
        if (this.size != indices.size()) {
            return false;
        }
        return this.equals(indices.getStructureOfIndices());
    }

    public StructureOfIndices getInverted() {
        if (this.size == 0) {
            return this;
        }
        StructureOfIndices r = new StructureOfIndices(this.size);
        System.arraycopy(this.typesCounts, 0, r.typesCounts, 0, this.typesCounts.length);
        for (int i = r.states.length - 1; i >= 0; --i) {
            if (this.states[i] == null) continue;
            if (this.states[i] == BitArray.EMPTY) {
                r.states[i] = BitArray.EMPTY;
            }
            r.states[i] = this.states[i].clone();
            r.states[i].not();
        }
        return r;
    }

    public StructureOfIndices append(StructureOfIndices oth) {
        if (this.size == 0) {
            return oth;
        }
        if (oth.size == 0) {
            return this;
        }
        int size = this.size + oth.size;
        StructureOfIndices r = new StructureOfIndices(size);
        for (int i = 0; i < 8; ++i) {
            r.typesCounts[i] = this.typesCounts[i] + oth.typesCounts[i];
            if (this.states[i] == null) continue;
            r.states[i] = this.states[i].append(oth.states[i]);
        }
        return r;
    }

    public StructureOfIndices pow(int N) {
        if (this.size == 0 || N == 0) {
            return StructureOfIndices.getEmpty();
        }
        if (N == 1) {
            return this;
        }
        int size = N * this.size;
        StructureOfIndices r = new StructureOfIndices(size);
        for (int i = 0; i < 8; ++i) {
            r.typesCounts[i] = N * this.typesCounts[i];
            if (this.states[i] == null) continue;
            r.states[i] = this.states[i].times(N);
        }
        return r;
    }

    public StructureOfIndices subtract(StructureOfIndices other) {
        int size = this.size - other.size;
        if (size < 0) {
            throw new IllegalArgumentException();
        }
        if (other.size == 0) {
            return this;
        }
        StructureOfIndices r = new StructureOfIndices(size);
        for (int i = 0; i < 8; ++i) {
            r.typesCounts[i] = this.typesCounts[i] - other.typesCounts[i];
            if (r.typesCounts[i] < 0) {
                throw new IllegalArgumentException("Other is larger then this.");
            }
            if (this.states[i] == null) continue;
            if (other.states[i] == null) {
                throw new IllegalArgumentException("Inconsistent structures: " + this + " and " + other);
            }
            if (!this.states[i].copyOfRange(this.states[i].size() - other.states[i].size()).equals(other.states[i])) {
                throw new IllegalArgumentException("Nonmetric states are different");
            }
            r.states[i] = this.states[i].copyOfRange(0, this.states[i].size() - other.states[i].size());
        }
        if (size == 0) {
            return StructureOfIndices.getEmpty();
        }
        return r;
    }

    public int[][] getPartitionMappings(StructureOfIndices ... partition) {
        int j;
        int c;
        for (int i = 0; i < 8; ++i) {
            c = 0;
            for (StructureOfIndices str : partition) {
                c += str.typesCounts[i];
            }
            if (c == this.typesCounts[i]) continue;
            throw new IllegalArgumentException("Not a partition.");
        }
        int[][] mappings = new int[partition.length][];
        int[] pointers = new int[8];
        for (j = 0; j < 8; ++j) {
            pointers[j] = this.getTypeData((byte)((byte)j)).from;
        }
        for (c = 0; c < partition.length; ++c) {
            mappings[c] = new int[partition[c].size];
            int i = 0;
            for (j = 0; j < 8; ++j) {
                for (int k = partition[c].typesCounts[j] - 1; k >= 0; --k) {
                    int n = i++;
                    int n2 = j;
                    int n3 = pointers[n2];
                    pointers[n2] = n3 + 1;
                    mappings[c][n] = n3;
                }
            }
            assert (i == partition[c].size);
        }
        return mappings;
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (int i = 0; i < 8; ++i) {
            int t;
            if (this.typesCounts[i] == 0) continue;
            sb.append('{');
            if (this.states[i] == null) {
                t = 0;
                while (true) {
                    sb.append(IndexType.values()[i].getShortString());
                    if (t != this.typesCounts[i] - 1) {
                        sb.append(',');
                        ++t;
                        continue;
                    }
                    break;
                }
            } else {
                for (t = 0; t < this.typesCounts[i]; ++t) {
                    sb.append('(');
                    sb.append(IndexType.values()[i].getShortString());
                    sb.append(',');
                    sb.append(this.states[i].get(t) ? 1 : 0);
                    sb.append(')');
                    if (t == this.typesCounts[i] - 1) break;
                    sb.append(',');
                }
            }
            sb.append("},");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(']');
        return sb.toString();
    }

    public static StructureOfIndices getEmpty() {
        if (EMPTY == null) {
            EMPTY = new StructureOfIndices();
        }
        return EMPTY;
    }

    public static class TypeData {
        public final int from;
        public final int length;
        public final BitArray states;

        TypeData(int from, int length, BitArray states) {
            this.from = from;
            this.length = length;
            this.states = states != null ? states.clone() : null;
        }
    }
}

