/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.indices;

import cc.redberry.core.context.IndexSymbolConverter;
import cc.redberry.core.context.defaults.IndexConverterExtender;
import cc.redberry.core.context.defaults.IndexWithStrokeConverter;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum IndexType {
    LatinLower(IndexConverterExtender.LatinLowerEx, "l"),
    LatinUpper(IndexConverterExtender.LatinUpperEx, "L"),
    GreekLower(IndexConverterExtender.GreekLowerEx, "g"),
    GreekUpper(IndexConverterExtender.GreekUpperEx, "G"),
    Matrix1(new IndexWithStrokeConverter(IndexConverterExtender.LatinLowerEx, 1), "l'"),
    Matrix2(new IndexWithStrokeConverter(IndexConverterExtender.LatinUpperEx, 1), "L'"),
    Matrix3(new IndexWithStrokeConverter(IndexConverterExtender.GreekLowerEx, 1), "g'"),
    Matrix4(new IndexWithStrokeConverter(IndexConverterExtender.GreekUpperEx, 1), "G'");

    private final IndexSymbolConverter converter;
    private final String shortString;
    private static final Map<String, IndexType> commonNames;
    private static final IndexType[] VALUES;
    private static final byte[] ALL_BYTES;
    private static final IndexSymbolConverter[] ALL_CONVERTERS;
    private static final EnumSet<IndexType> ALL_TYPES;
    private static final IndexType[] BYTE_TO_ENUM;
    public static final byte TYPES_COUNT = 8;
    public static final byte ALPHABETS_COUNT = 4;

    private IndexType(IndexSymbolConverter converter, String shortString) {
        this.shortString = shortString;
        this.converter = converter;
    }

    public IndexSymbolConverter getSymbolConverter() {
        return this.converter;
    }

    public String getShortString() {
        return this.shortString;
    }

    public byte getType() {
        return this.converter.getType();
    }

    public static IndexType fromShortString(String shortName) {
        return commonNames.get(shortName);
    }

    public static byte[] getBytes() {
        return (byte[])ALL_BYTES.clone();
    }

    public static IndexType getType(byte type) {
        if (type >= 8 || type < 0) {
            throw new IllegalArgumentException("Now such type: " + type);
        }
        return BYTE_TO_ENUM[type];
    }

    public static IndexSymbolConverter[] getAllConverters() {
        return (IndexSymbolConverter[])ALL_CONVERTERS.clone();
    }

    static {
        commonNames = new HashMap<String, IndexType>();
        VALUES = IndexType.values();
        ALL_BYTES = new byte[VALUES.length];
        ALL_CONVERTERS = new IndexSymbolConverter[VALUES.length];
        ALL_TYPES = EnumSet.allOf(IndexType.class);
        BYTE_TO_ENUM = new IndexType[VALUES.length];
        for (int i = 0; i < VALUES.length; ++i) {
            commonNames.put(VALUES[i].getShortString(), VALUES[i]);
            IndexType.BYTE_TO_ENUM[IndexType.VALUES[i].getType()] = VALUES[i];
            IndexType.ALL_BYTES[i] = VALUES[i].getType();
            IndexType.ALL_CONVERTERS[i] = VALUES[i].getSymbolConverter();
        }
    }
}

