/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.indexmapping;

import cc.redberry.core.indexmapping.IndexMappingBuffer;
import cc.redberry.core.indexmapping.IndexMappingProvider;
import cc.redberry.core.indexmapping.IndexMappings;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.utils.OutputPort;

final class SimpleProductMappingsPort
implements OutputPort<IndexMappingBuffer> {
    private final IndexMappingProvider[] providers;
    private boolean inited = false;

    SimpleProductMappingsPort(IndexMappingProvider[] providers) {
        this.providers = providers;
    }

    SimpleProductMappingsPort(IndexMappingProvider opu, Tensor[] from, Tensor[] to) {
        this.providers = new IndexMappingProvider[from.length];
        this.providers[0] = IndexMappings.createPort(opu, from[0], to[0]);
        for (int i = 1; i < from.length; ++i) {
            this.providers[i] = IndexMappings.createPort(this.providers[i - 1], from[i], to[i]);
        }
    }

    @Override
    public IndexMappingBuffer take() {
        IndexMappingBuffer buffer;
        int i;
        if (!this.inited) {
            for (i = 0; i < this.providers.length; ++i) {
                this.providers[i].tick();
            }
            this.inited = true;
        }
        if ((buffer = (IndexMappingBuffer)this.providers[i = this.providers.length - 1].take()) != null) {
            return buffer;
        }
        block1: while (true) {
            boolean r;
            if ((r = !this.providers[i--].tick()) && i >= 0) {
                continue;
            }
            if (i == -1 && r) {
                return null;
            }
            i += 2;
            while (i < this.providers.length) {
                if (!this.providers[i].tick()) {
                    --i;
                    continue block1;
                }
                ++i;
            }
            assert (i == this.providers.length);
            if ((buffer = (IndexMappingBuffer)this.providers[--i].take()) != null) break;
        }
        return buffer;
    }
}

