/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.indexmapping;

import cc.redberry.core.combinatorics.IntPermutationsGenerator;
import cc.redberry.core.indexmapping.FromToHolder;
import cc.redberry.core.indexmapping.IndexMappingBuffer;
import cc.redberry.core.indexmapping.IndexMappingBufferTester;
import cc.redberry.core.indexmapping.IndexMappingProvider;
import cc.redberry.core.indexmapping.IndexMappingProviderAbstract;
import cc.redberry.core.indexmapping.IndexMappingProviderFactory;
import cc.redberry.core.indexmapping.IndexMappings;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.utils.OutputPort;
import java.util.ArrayList;

final class ProviderSum
implements IndexMappingProvider {
    static final IndexMappingProviderFactory FACTORY = new IndexMappingProviderFactory(){

        @Override
        public IndexMappingProvider create(IndexMappingProvider opu, Tensor from, Tensor to) {
            if (from.size() != to.size()) {
                return IndexMappingProvider.Util.EMPTY_PROVIDER;
            }
            for (int i = 0; i < from.size(); ++i) {
                if (from.get(i).hashCode() == to.get(i).hashCode()) continue;
                return IndexMappingProvider.Util.EMPTY_PROVIDER;
            }
            return new ProviderSum(opu, from, to);
        }
    };
    private final IndexMappingProvider mainProvider;
    private final Tester[] testers;
    private final InputCache cache;

    private ProviderSum(IndexMappingProvider opu, Tensor from, Tensor to) {
        int begin = 0;
        int size = from.size();
        int mainStretchCoord = -1;
        int mainStretchIndex = -1;
        int mainStretchLength = Integer.MAX_VALUE;
        ArrayList<Tester> testersList = new ArrayList<Tester>();
        for (int i = 1; i <= size; ++i) {
            if (i != size && from.get(i).hashCode() == from.get(i - 1).hashCode()) continue;
            testersList.add(i - begin == 1 ? new SinglePairTester(from.get(begin), to.get(begin)) : new StretchPairTester(from.getRange(begin, i), to.getRange(begin, i)));
            if (mainStretchLength > i - begin) {
                mainStretchCoord = begin;
                mainStretchLength = i - begin;
                mainStretchIndex = testersList.size() - 1;
            }
            begin = i;
        }
        this.cache = new InputCache(opu);
        if (mainStretchLength == 1) {
            this.mainProvider = IndexMappings.createPort(this.cache, from.get(mainStretchCoord), to.get(mainStretchCoord));
            testersList.remove(mainStretchIndex);
        } else {
            Tensor[] preFrom = from.getRange(mainStretchCoord, mainStretchCoord + mainStretchLength);
            Tensor[] preTo = to.getRange(mainStretchCoord, mainStretchCoord + mainStretchLength);
            this.mainProvider = new StretchPairSource(this.cache, preFrom, preTo);
            testersList.set(mainStretchIndex, (StretchPairSource)this.mainProvider);
        }
        this.testers = testersList.toArray(new Tester[testersList.size()]);
    }

    @Override
    public boolean tick() {
        return this.mainProvider.tick();
    }

    @Override
    public IndexMappingBuffer take() {
        IndexMappingBuffer buffer;
        block0: while (true) {
            if ((buffer = (IndexMappingBuffer)this.mainProvider.take()) == null) {
                return null;
            }
            buffer.removeContracted();
            IndexMappingBufferTester tester = new IndexMappingBufferTester(buffer.export().mergeWith(this.cache.lastReturned));
            for (Tester t : this.testers) {
                if (!t.test(tester)) continue block0;
            }
            break;
        }
        return buffer;
    }

    private static class SinglePairTester
    implements Tester {
        private final Tensor from;
        private final Tensor to;

        public SinglePairTester(Tensor from, Tensor to) {
            this.from = from;
            this.to = to;
        }

        @Override
        public boolean test(IndexMappingBufferTester tester) {
            return IndexMappingBufferTester.test(tester, this.from, this.to);
        }
    }

    private static class StretchPairTester
    implements Tester {
        private final Tensor[] from;
        private final Tensor[] to;
        private final int length;

        public StretchPairTester(Tensor[] from, Tensor[] to) {
            this.from = from;
            this.to = to;
            this.length = from.length;
        }

        @Override
        public boolean test(IndexMappingBufferTester tester) {
            boolean[] bijection = new boolean[this.length];
            for (int i = 0; i < this.length; ++i) {
                block3: {
                    for (int j = 0; j < this.length; ++j) {
                        if (bijection[j] || !IndexMappingBufferTester.test(tester, this.from[j], this.to[i])) {
                            continue;
                        }
                        break block3;
                    }
                    return false;
                }
                bijection[j] = true;
            }
            return true;
        }
    }

    private static class StretchPairSource
    extends IndexMappingProviderAbstract
    implements Tester {
        private final Tensor[] from;
        private final Tensor[] to;
        private final IntPermutationsGenerator permutationGenerator;
        private OutputPort<IndexMappingBuffer> currentSource = null;
        private int[] currentPermutation;

        public StretchPairSource(OutputPort<IndexMappingBuffer> opu, Tensor[] from, Tensor[] to) {
            super(opu);
            this.from = from;
            this.to = to;
            this.permutationGenerator = new IntPermutationsGenerator(from.length);
        }

        @Override
        public IndexMappingBuffer take() {
            if (this.currentBuffer == null) {
                return null;
            }
            IndexMappingBuffer buf;
            while (this.currentSource == null || (buf = this.currentSource.take()) == null) {
                if (!this.permutationGenerator.hasNext()) {
                    this.currentBuffer = null;
                    return null;
                }
                this.currentPermutation = this.permutationGenerator.next();
                this.currentSource = IndexMappings.createPortOfBuffers(this.currentBuffer.clone(), this.from[0], this.to[this.currentPermutation[0]]);
            }
            return buf;
        }

        @Override
        protected void _tick() {
            this.permutationGenerator.reset();
        }

        @Override
        public boolean test(IndexMappingBufferTester tester) {
            for (int i = 1; i < this.from.length; ++i) {
                if (IndexMappingBufferTester.test(tester, this.from[i], this.to[this.currentPermutation[i]])) continue;
                return false;
            }
            return true;
        }
    }

    private static interface Tester {
        public boolean test(IndexMappingBufferTester var1);
    }

    private static class InputCache
    implements IndexMappingProvider {
        private final IndexMappingProvider provider;
        FromToHolder lastReturned;

        public InputCache(IndexMappingProvider provider) {
            this.provider = provider;
        }

        @Override
        public boolean tick() {
            return this.provider.tick();
        }

        @Override
        public IndexMappingBuffer take() {
            IndexMappingBuffer buffer = (IndexMappingBuffer)this.provider.take();
            if (buffer == null) {
                return null;
            }
            this.lastReturned = buffer.export();
            return buffer;
        }
    }
}

