/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.indexmapping;

import cc.redberry.core.combinatorics.IntPermutationsGenerator;
import cc.redberry.core.indexmapping.IndexMappingBuffer;
import cc.redberry.core.indexmapping.IndexMappingProvider;
import cc.redberry.core.indexmapping.IndexMappingProviderAbstract;
import cc.redberry.core.indexmapping.SimpleProductMappingsPort;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.utils.OutputPort;

final class PermutatorProvider
extends IndexMappingProviderAbstract {
    private final IntPermutationsGenerator generator;
    private final Tensor[] from;
    private final Tensor[] to;
    private SimpleProductMappingsPort currentProvider = null;

    PermutatorProvider(OutputPort<IndexMappingBuffer> opu, Tensor[] from, Tensor[] to) {
        super(opu);
        this.from = from;
        this.to = to;
        this.generator = new IntPermutationsGenerator(from.length);
    }

    @Override
    public void _tick() {
        this.generator.reset();
    }

    @Override
    public IndexMappingBuffer take() {
        if (this.currentBuffer == null) {
            return null;
        }
        while (this.currentProvider == null) {
            if (!this.generator.hasNext()) {
                return null;
            }
            int[] permutation = this.generator.next();
            Tensor[] newTo = new Tensor[this.to.length];
            for (int i = 0; i < this.to.length; ++i) {
                newTo[i] = this.to[permutation[i]];
            }
            this.currentProvider = new SimpleProductMappingsPort(IndexMappingProvider.Util.singleton(this.currentBuffer.clone()), this.from, newTo);
            IndexMappingBuffer buffer = this.currentProvider.take();
            if (buffer != null) {
                return buffer;
            }
            this.currentProvider = null;
        }
        IndexMappingBuffer buffer = this.currentProvider.take();
        if (buffer == null) {
            this.currentProvider = null;
            return this.take();
        }
        return buffer;
    }
}

