/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.indexmapping;

import cc.redberry.core.indexmapping.IndexMappingBuffer;
import cc.redberry.core.indexmapping.IndexMappingBufferRecord;
import cc.redberry.core.indices.IndicesUtils;
import cc.redberry.core.tensor.ApplyIndexMapping;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.transformations.Transformation;
import cc.redberry.core.utils.ArraysUtils;
import cc.redberry.core.utils.IntArray;
import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.Arrays;

public final class Mapping
implements Transformation {
    final int[] fromNames;
    final int[] toData;
    final boolean sign;
    public static final Mapping IDENTITY = new Mapping(new int[0], new int[0], false, false);

    public Mapping(int[] from, int[] to) {
        this(from, to, false);
    }

    public Mapping(int[] from, int[] to, boolean sign) {
        if (from.length != to.length) {
            throw new IllegalArgumentException("From length != to length.");
        }
        this.fromNames = new int[from.length];
        this.toData = new int[from.length];
        for (int i = 0; i < from.length; ++i) {
            this.fromNames[i] = IndicesUtils.getNameWithType(from[i]);
            this.toData[i] = IndicesUtils.getRawStateInt(from[i]) ^ to[i];
        }
        ArraysUtils.quickSort(this.fromNames, this.toData);
        this.sign = sign;
    }

    Mapping(IndexMappingBuffer buffer) {
        TIntObjectHashMap<IndexMappingBufferRecord> map = buffer.getMap();
        this.fromNames = new int[map.size()];
        this.toData = new int[map.size()];
        TIntObjectIterator iterator = map.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            iterator.advance();
            IndexMappingBufferRecord record = (IndexMappingBufferRecord)iterator.value();
            this.fromNames[i] = iterator.key();
            this.toData[i] = record.getRawDiffStateBit() | record.getIndexName();
            ++i;
        }
        ArraysUtils.quickSort(this.fromNames, this.toData);
        this.sign = buffer.getSign();
    }

    private Mapping(int[] fromNames, int[] toData, boolean sign, boolean o) {
        this.fromNames = fromNames;
        this.toData = toData;
        this.sign = sign;
    }

    @Override
    public Tensor transform(Tensor t) {
        return ApplyIndexMapping.applyIndexMappingAutomatically(t, this);
    }

    public boolean isEmpty() {
        return this.fromNames.length == 0;
    }

    public boolean isIdentity() {
        return this.fromNames.length == 0 && !this.sign;
    }

    public boolean getSign() {
        return this.sign;
    }

    public Mapping addSign(boolean sign) {
        return new Mapping(this.fromNames, this.toData, sign ^ this.sign, true);
    }

    public int size() {
        return this.fromNames.length;
    }

    public IntArray getFromNames() {
        return new IntArray(this.fromNames);
    }

    public IntArray getToData() {
        return new IntArray(this.toData);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Mapping mapping = (Mapping)o;
        if (this.sign != mapping.sign) {
            return false;
        }
        if (!Arrays.equals(this.fromNames, mapping.fromNames)) {
            return false;
        }
        return Arrays.equals(this.toData, mapping.toData);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.fromNames);
        result = 31 * result + Arrays.hashCode(this.toData);
        result = 31 * result + (this.sign ? 1 : 0);
        return result;
    }

    public String toString() {
        int imax = this.fromNames.length - 1;
        if (imax == -1) {
            if (this.sign) {
                return "-{}";
            }
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        if (this.sign) {
            sb.append("-");
        }
        sb.append("{");
        int i = 0;
        while (true) {
            sb.append(IndicesUtils.toString(this.fromNames[i]));
            sb.append("->");
            sb.append(IndicesUtils.toString(this.toData[i]));
            if (i == imax) break;
            sb.append(", ");
            ++i;
        }
        sb.append("}");
        return sb.toString();
    }

    public static Mapping valueOf(String string) {
        string = string.trim();
        int start = 0;
        boolean sign = false;
        if (string.charAt(0) == '-') {
            sign = true;
            start = 1;
        } else if (string.charAt(0) == '+') {
            start = 1;
        }
        if (string.charAt(start) != '{' || string.charAt(string.length() - 1) != '}') {
            throw new IllegalArgumentException("Not valid syntax for mapping: " + string);
        }
        string = string.substring(start + 1, string.length() - 1).trim();
        String[] split = string.split(",");
        int[] from = new int[split.length];
        int[] to = new int[split.length];
        for (int i = 0; i < split.length; ++i) {
            String[] fromTo = split[i].split("->");
            if (fromTo.length != 2) {
                throw new IllegalArgumentException("Not valid syntax for mapping: " + string);
            }
            int fromIndex = IndicesUtils.parseIndex(fromTo[0]);
            from[i] = IndicesUtils.getNameWithType(fromIndex);
            to[i] = IndicesUtils.getRawStateInt(fromIndex) ^ IndicesUtils.parseIndex(fromTo[1]);
        }
        return new Mapping(from, to, sign);
    }
}

