/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.groups.permutations;

import cc.redberry.core.context.CC;
import cc.redberry.core.groups.permutations.Permutation;
import java.util.List;
import org.apache.commons.math3.random.RandomGenerator;

public final class RandomPermutation {
    public static final int DEFAULT_RANDOMNESS_EXTEND_TO_SIZE = 10;
    public static final int DEFAULT_NUMBER_OF_RANDOM_REFINEMENTS = 20;

    private RandomPermutation() {
    }

    public static void randomness(List<Permutation> generators) {
        RandomPermutation.randomness(generators, 10, 20, CC.getRandomGenerator());
    }

    public static void randomness(List<Permutation> generators, int extendToSize, int numberOfRefinements, RandomGenerator random) {
        if (generators.size() < 2 && extendToSize < 2) {
            throw new IllegalArgumentException("List should extended by at least one element.");
        }
        if (generators.size() < extendToSize) {
            int delta = extendToSize - generators.size() + 1;
            int i = 0;
            while (--delta >= 0) {
                generators.add(generators.get(i++));
            }
        }
        if (!generators.get(generators.size() - 1).isIdentity()) {
            generators.add(generators.get(0).getIdentity());
        }
        while (--numberOfRefinements >= 0) {
            RandomPermutation.random(generators, random);
        }
    }

    public static Permutation random(List<Permutation> generators) {
        return RandomPermutation.random(generators, CC.getRandomGenerator());
    }

    public static Permutation random(List<Permutation> generators, RandomGenerator random) {
        int t;
        if (generators.size() < 3) {
            throw new IllegalArgumentException("List size should be >= 3");
        }
        int generatorsSize = generators.size() - 1;
        int s = random.nextInt(generatorsSize);
        while ((t = random.nextInt(generatorsSize)) == s) {
        }
        Permutation ps = generators.get(s);
        Permutation pt = generators.get(t);
        Permutation x0 = generators.get(generatorsSize);
        if (random.nextBoolean()) {
            pt = pt.inverse();
        }
        if (random.nextBoolean()) {
            ps = ps.composition(pt);
            generators.set(s, ps);
            x0 = x0.composition(ps);
            generators.set(generatorsSize, x0);
        } else {
            ps = pt.composition(ps);
            generators.set(s, ps);
            x0 = ps.composition(x0);
            generators.set(generatorsSize, x0);
        }
        return x0;
    }
}

