/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.groups.permutations;

import cc.redberry.core.groups.permutations.AlgorithmsBase;
import cc.redberry.core.groups.permutations.BSGSElement;
import cc.redberry.core.groups.permutations.BacktrackSearchTestFunction;
import cc.redberry.core.groups.permutations.InducedOrdering;
import cc.redberry.core.groups.permutations.Permutation;
import cc.redberry.core.utils.ArraysUtils;
import cc.redberry.core.utils.Indicator;
import cc.redberry.core.utils.IntComparator;
import cc.redberry.core.utils.OutputPort;
import java.util.Arrays;
import java.util.List;

public final class BacktrackSearch
implements OutputPort<Permutation> {
    final List<? extends BSGSElement> bsgs;
    final int[] tuple;
    int[][] sortedOrbits;
    int level = 0;
    Permutation[] word;
    final int size;
    final IntComparator ordering;
    final int[][] cachedSortedOrbits;
    BacktrackSearchTestFunction testFunction;
    Indicator<Permutation> property;

    public BacktrackSearch(List<? extends BSGSElement> bsgs, BacktrackSearchTestFunction test, Indicator<Permutation> property) {
        if (bsgs.size() == 0) {
            throw new IllegalArgumentException("Empty BSGS.");
        }
        this.bsgs = bsgs;
        this.size = bsgs.size();
        this.tuple = new int[this.size];
        Arrays.fill(this.tuple, -1);
        this.ordering = new InducedOrdering(AlgorithmsBase.getBaseAsArray(bsgs));
        this.word = new Permutation[bsgs.size()];
        this.sortedOrbits = new int[bsgs.size()][];
        this.cachedSortedOrbits = new int[bsgs.size()][];
        for (int i = bsgs.size() - 1; i >= 0; --i) {
            this.cachedSortedOrbits[i] = bsgs.get((int)i).orbitList.toArray();
            ArraysUtils.quickSort(this.cachedSortedOrbits[i], this.ordering);
        }
        this.sortedOrbits[0] = this.cachedSortedOrbits[0];
        this.testFunction = test;
        this.property = property;
    }

    public BacktrackSearch(List<? extends BSGSElement> bsgs) {
        this(bsgs, BacktrackSearchTestFunction.TRUE, Indicator.TRUE_INDICATOR);
    }

    public BacktrackSearchTestFunction getTestFunction() {
        return this.testFunction;
    }

    public void setTestFunction(BacktrackSearchTestFunction test) {
        this.testFunction = test;
    }

    public Indicator<Permutation> getProperty() {
        return this.property;
    }

    public void setProperty(Indicator<Permutation> property) {
        this.property = property;
    }

    public IntComparator getInducedOrdering() {
        return this.ordering;
    }

    public int lastModifiedLevel() {
        return this.level;
    }

    public Permutation[] getWordReference() {
        return this.word;
    }

    @Override
    public Permutation take() {
        if (this.level == -1) {
            return null;
        }
        do {
            this.backtrack();
            if (this.level == -1) {
                return null;
            }
            while (this.level < this.size - 1 && this.testFunction.test(this.word[this.level], this.level)) {
                ++this.level;
                this.calculateSortedOrbit(this.level);
                this.tuple[this.level] = 0;
                this.word[this.level] = this.bsgs.get(this.level).getTransversalOf(this.word[this.level - 1].newIndexOfUnderInverse(this.sortedOrbits[this.level][this.tuple[this.level]])).composition(this.word[this.level - 1]);
            }
        } while (this.level != this.size - 1 || !this.testFunction.test(this.word[this.level], this.level) || !this.property.is(this.word[this.level]));
        return this.word[this.level];
    }

    private void backtrack() {
        while (this.level >= 0 && this.tuple[this.level] == this.bsgs.get((int)this.level).orbitList.size() - 1) {
            --this.level;
        }
        if (this.level == -1) {
            return;
        }
        int n = this.level;
        this.tuple[n] = this.tuple[n] + 1;
        if (this.level == 0) {
            this.word[0] = this.bsgs.get(0).getTransversalOf(this.sortedOrbits[0][this.tuple[0]]);
        } else {
            this.word[this.level] = this.bsgs.get(this.level).getTransversalOf(this.word[this.level - 1].newIndexOfUnderInverse(this.sortedOrbits[this.level][this.tuple[this.level]])).composition(this.word[this.level - 1]);
        }
    }

    private void calculateSortedOrbit(int level) {
        if (this.word[level - 1].isIdentity()) {
            this.sortedOrbits[level] = this.cachedSortedOrbits[level];
        } else {
            this.sortedOrbits[level] = this.word[level - 1].imageOf(this.bsgs.get((int)level).orbitList.toArray());
            ArraysUtils.quickSort(this.sortedOrbits[level], this.ordering);
        }
    }
}

