/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.context;

import cc.redberry.core.context.NameAndStructureOfIndices;
import cc.redberry.core.context.NameDescriptorForTensorField;
import cc.redberry.core.context.NameDescriptorForTensorFieldDerivative;
import cc.redberry.core.context.OutputFormat;
import cc.redberry.core.indices.SimpleIndices;
import cc.redberry.core.indices.StructureOfIndices;
import java.util.Arrays;
import java.util.HashMap;

final class NameDescriptorForTensorFieldImpl
extends NameDescriptorForTensorField {
    final HashMap<DerivativeDescriptor, NameDescriptorForTensorFieldDerivative> derivatives = new HashMap();
    final NameAndStructureOfIndices[] keys;

    public NameDescriptorForTensorFieldImpl(String name, StructureOfIndices[] indexTypeStructures, int id) {
        super(indexTypeStructures, id, new int[indexTypeStructures.length - 1], name);
        this.keys = new NameAndStructureOfIndices[]{new NameAndStructureOfIndices(name, indexTypeStructures)};
    }

    @Override
    NameAndStructureOfIndices[] getKeys() {
        return this.keys;
    }

    @Override
    public String getName(SimpleIndices indices, OutputFormat format) {
        return this.name;
    }

    @Override
    public boolean isDerivative() {
        return false;
    }

    @Override
    public NameDescriptorForTensorField getParent() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NameDescriptorForTensorField getDerivative(int ... orders) {
        if (orders.length != this.structuresOfIndices.length - 1) {
            throw new IllegalArgumentException();
        }
        boolean b = true;
        for (int o : orders) {
            if (o < 0) {
                throw new IllegalArgumentException("Negative derivative order.");
            }
            if (o == 0) continue;
            b = false;
        }
        if (b) {
            return this;
        }
        DerivativeDescriptor derivativeDescriptor = new DerivativeDescriptor(orders);
        NameDescriptorForTensorFieldDerivative nd = this.derivatives.get(derivativeDescriptor);
        if (nd == null) {
            NameDescriptorForTensorFieldImpl nameDescriptorForTensorFieldImpl = this;
            synchronized (nameDescriptorForTensorFieldImpl) {
                nd = this.derivatives.get(derivativeDescriptor);
                if (nd == null) {
                    nd = this.nameManager.createDescriptorForFieldDerivative(this, orders);
                    this.derivatives.put(derivativeDescriptor, nd);
                }
            }
        }
        return nd;
    }

    private static final class DerivativeDescriptor {
        final int[] orders;

        private DerivativeDescriptor(int[] orders) {
            this.orders = orders;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DerivativeDescriptor that = (DerivativeDescriptor)o;
            return Arrays.equals(this.orders, that.orders);
        }

        public int hashCode() {
            return Arrays.hashCode(this.orders);
        }
    }
}

