/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.context;

import cc.redberry.core.context.NameAndStructureOfIndices;
import cc.redberry.core.context.NameDescriptorForTensorField;
import cc.redberry.core.context.NameDescriptorForTensorFieldImpl;
import cc.redberry.core.context.OutputFormat;
import cc.redberry.core.groups.permutations.Permutation;
import cc.redberry.core.groups.permutations.Permutations;
import cc.redberry.core.indices.SimpleIndices;
import cc.redberry.core.indices.StructureOfIndices;
import cc.redberry.core.utils.ArraysUtils;
import cc.redberry.core.utils.IntArrayList;

final class NameDescriptorForTensorFieldDerivative
extends NameDescriptorForTensorField {
    final NameDescriptorForTensorFieldImpl parent;

    NameDescriptorForTensorFieldDerivative(int id, int[] orders, NameDescriptorForTensorFieldImpl parent) {
        super(NameDescriptorForTensorFieldDerivative.generateStructures(parent, orders), id, orders, NameDescriptorForTensorFieldDerivative.generateName(orders, parent));
        this.parent = parent;
        this.initializeSymmetries();
    }

    @Override
    public NameDescriptorForTensorField getParent() {
        return this.parent;
    }

    @Override
    NameAndStructureOfIndices[] getKeys() {
        return new NameAndStructureOfIndices[0];
    }

    @Override
    public String getName(SimpleIndices indices, OutputFormat format) {
        if (format.is(OutputFormat.WolframMathematica)) {
            String[] spl = this.name.split("~");
            return "Derivative" + spl[1].replace("(", "[").replace(")", "]") + "[" + spl[0] + "]";
        }
        if (format.is(OutputFormat.Maple)) {
            StringBuilder sb = new StringBuilder();
            sb.append("D[");
            for (int j = 0; j < this.orders.length; ++j) {
                for (int i = 0; i < this.orders[j]; ++i) {
                    sb.append(j + 1).append(",");
                }
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append("]").append("(");
            sb.append(this.name.split("~")[0]).append(")");
            return sb.toString();
        }
        return this.name;
    }

    @Override
    public boolean isDerivative() {
        return true;
    }

    @Override
    public NameDescriptorForTensorField getDerivative(int ... orders) {
        if (orders.length != this.structuresOfIndices.length - 1) {
            throw new IllegalArgumentException();
        }
        int[] resOrder = (int[])this.orders.clone();
        for (int i = orders.length - 1; i >= 0; --i) {
            int n = i;
            resOrder[n] = resOrder[n] + orders[i];
        }
        return this.parent.getDerivative(resOrder);
    }

    private void initializeSymmetries() {
        int j;
        int i;
        StructureOfIndices baseStructure = this.structuresOfIndices[0];
        StructureOfIndices[] partition = new StructureOfIndices[1 + ArraysUtils.sum(this.orders)];
        partition[0] = this.parent.structuresOfIndices[0];
        int k = 0;
        for (i = 0; i < this.orders.length; ++i) {
            for (j = 0; j < this.orders[i]; ++j) {
                partition[++k] = this.structuresOfIndices[i + 1].getInverted();
            }
        }
        int[][] mapping = baseStructure.getPartitionMappings(partition);
        for (Permutation p : this.parent.symmetries.getGenerators()) {
            this.symmetries.addSymmetry(NameDescriptorForTensorFieldDerivative.convertPermutation(p, mapping[0], baseStructure.size()));
        }
        IntArrayList aggregator = new IntArrayList();
        j = 1;
        for (i = 0; i < this.orders.length; ++i) {
            if (this.structuresOfIndices[i + 1].size() != 0 && this.orders[i] >= 2) {
                int[] cycle = Permutations.createBlockCycle(this.structuresOfIndices[i + 1].size(), 2);
                aggregator.addAll(mapping[j]);
                aggregator.addAll(mapping[j + 1]);
                this.symmetries.addSymmetry(Permutations.createPermutation(NameDescriptorForTensorFieldDerivative.convertPermutation(cycle, aggregator.toArray(), baseStructure.size())));
                if (this.orders[i] >= 3) {
                    for (k = 2; k < this.orders[i]; ++k) {
                        aggregator.addAll(mapping[j + k]);
                    }
                    cycle = Permutations.createBlockCycle(this.structuresOfIndices[i + 1].size(), this.orders[i]);
                    this.symmetries.addSymmetry(Permutations.createPermutation(NameDescriptorForTensorFieldDerivative.convertPermutation(cycle, aggregator.toArray(), baseStructure.size())));
                }
                aggregator.clear();
            }
            j += this.orders[i];
        }
    }

    static Permutation convertPermutation(Permutation permutation, int[] mapping, int newDimension) {
        return Permutations.createPermutation(permutation.antisymmetry(), NameDescriptorForTensorFieldDerivative.convertPermutation(permutation.oneLine(), mapping, newDimension));
    }

    static int[] convertPermutation(int[] permutation, int[] mapping, int newDimension) {
        assert (permutation.length == mapping.length);
        int[] result = new int[newDimension];
        for (int i = 0; i < newDimension; ++i) {
            result[i] = i;
        }
        for (int i = permutation.length - 1; i >= 0; --i) {
            if (mapping[i] == -1) continue;
            int k = mapping[permutation[i]];
            assert (k != -1);
            result[mapping[i]] = k;
        }
        return result;
    }

    private static String generateName(int[] orders, NameDescriptorForTensorFieldImpl parent) {
        StringBuilder sb = new StringBuilder();
        sb.append(parent.name);
        sb.append('~');
        sb.append('(');
        int i = 0;
        while (true) {
            sb.append(orders[i]);
            if (i == orders.length - 1) break;
            sb.append(',');
            ++i;
        }
        sb.append(')');
        return sb.toString();
    }

    private static StructureOfIndices[] generateStructures(NameDescriptorForTensorFieldImpl parent, int[] orders) {
        StructureOfIndices[] structureOfIndices = (StructureOfIndices[])parent.structuresOfIndices.clone();
        for (int i = 0; i < orders.length; ++i) {
            for (int j = 0; j < orders[i]; ++j) {
                structureOfIndices[0] = structureOfIndices[0].append(structureOfIndices[i + 1].getInverted());
            }
        }
        return structureOfIndices;
    }
}

